/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.select.programtree;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import ghidra.app.events.ProgramSelectionPluginEvent;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.plugin.core.programtree.ProgramNode;
import ghidra.app.services.ProgramTreeService;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Group;
import ghidra.program.model.listing.ProgramFragment;
import ghidra.program.model.listing.ProgramModule;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HelpLocation;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Program Tree", shortDescription="Selects addresses from Program Tree", description="Allows the user to select code in the code browser from a selection of nodes (modules and fragments) in the Program Tree.", servicesRequired={ProgramTreeService.class})
public class ProgramTreeSelectionPlugin
extends ProgramPlugin {
    private TreeSelectAction selectModuleAction;

    public ProgramTreeSelectionPlugin(PluginTool tool) {
        super(tool, true, true);
        this.createActions();
    }

    private void createActions() {
        this.selectModuleAction = new TreeSelectAction(this.getName());
        this.tool.addAction((DockingActionIf)this.selectModuleAction);
    }

    private void selectModule(ActionContext context) {
        AddressSet addressSet = new AddressSet();
        ProgramNode node = (ProgramNode)context.getContextObject();
        JTree tree = node.getTree();
        int count = tree.getSelectionCount();
        TreePath[] paths = node.getTree().getSelectionPaths();
        for (int i = 0; i < count; ++i) {
            TreePath path = paths[i];
            ProgramNode pNode = (ProgramNode)path.getLastPathComponent();
            this.getAddressSet(pNode.getGroup(), addressSet);
        }
        ProgramSelection selection = new ProgramSelection((AddressSetView)addressSet);
        ProgramSelectionPluginEvent pspe = new ProgramSelectionPluginEvent("Selection", selection, node.getProgram());
        this.firePluginEvent(pspe);
    }

    private void getAddressSet(Group group, AddressSet set) {
        if (group instanceof ProgramFragment) {
            set.add((AddressSetView)((ProgramFragment)group));
        } else {
            Group[] groups;
            for (Group group2 : groups = ((ProgramModule)group).getChildren()) {
                this.getAddressSet(group2, set);
            }
        }
    }

    private class TreeSelectAction
    extends DockingAction {
        TreeSelectAction(String owner) {
            super("select addresses", owner);
            this.setPopupMenuData(new MenuData(new String[]{"Select Addresses"}, null, "select"));
            this.setEnabled(true);
            this.setHelpLocation(new HelpLocation("ProgramTreePlugin", "SelectAddresses"));
        }

        public boolean isEnabledForContext(ActionContext context) {
            Object activeObj = context.getContextObject();
            if (activeObj instanceof ProgramNode) {
                return ((ProgramNode)activeObj).getProgram() != null;
            }
            return false;
        }

        public void actionPerformed(ActionContext context) {
            ProgramTreeSelectionPlugin.this.selectModule(context);
        }
    }
}

