/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.reloc;

import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.plugin.core.reloc.RelocationFixupCommand;
import ghidra.app.plugin.core.reloc.RelocationFixupHandler;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.util.classfinder.ClassSearcher;
import java.util.ArrayList;
import java.util.List;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Code Viewer", shortDescription="Attempts to fix up relocations when a program's image base is changed", description="Listens for image base changes and attempts to fix up relocations.It searches for relocation algorithms based on format and relocation type.")
public class RelocationFixupPlugin
extends ProgramPlugin
implements DomainObjectListener {
    private List<RelocationFixupHandler> relocationHandlerList = new ArrayList<RelocationFixupHandler>();

    public RelocationFixupPlugin(PluginTool tool) {
        super(tool, false, false);
        this.initializeRelocationHandlers();
    }

    private void initializeRelocationHandlers() {
        this.relocationHandlerList.addAll(ClassSearcher.getInstances(RelocationFixupHandler.class));
    }

    @Override
    protected void programActivated(Program program) {
        program.addListener((DomainObjectListener)this);
    }

    @Override
    protected void programDeactivated(Program program) {
        program.removeListener((DomainObjectListener)this);
    }

    public void domainObjectChanged(DomainObjectChangedEvent ev) {
        if (!ev.containsEvent(27)) {
            return;
        }
        for (DomainObjectChangeRecord record : ev) {
            if (record.getEventType() != 27) continue;
            Address oldImageBase = (Address)record.getOldValue();
            Address newImageBase = (Address)record.getNewValue();
            this.imageBaseChanged(oldImageBase, newImageBase);
        }
    }

    private void imageBaseChanged(Address oldImageBase, Address newImageBase) {
        RelocationFixupHandler handler = this.findRelocationHandler();
        RelocationFixupCommand relocationFixupCommand = new RelocationFixupCommand(handler, oldImageBase, newImageBase);
        this.tool.executeBackgroundCommand((BackgroundCommand)relocationFixupCommand, (UndoableDomainObject)this.currentProgram);
    }

    private RelocationFixupHandler findRelocationHandler() {
        for (RelocationFixupHandler handler : this.relocationHandlerList) {
            if (!handler.handlesProgram(this.currentProgram)) continue;
            return handler;
        }
        return null;
    }
}

