/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.programtree;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.EditListener;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.widgets.tabbedpane.DockingTabRenderer;
import ghidra.app.plugin.core.programtree.ViewManagerComponentProvider;
import ghidra.app.plugin.core.programtree.ViewProviderService;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.util.ProgramLocation;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class ViewPanel
extends JPanel
implements ChangeListener {
    private JTabbedPane tabbedPane;
    private ViewManagerComponentProvider provider;
    private HashMap<String, ViewProviderService> map;
    private DockingAction closeAction;
    private DockingAction deleteAction;
    private DockingAction renameAction;
    private DockingAction[] localActions;
    private PluginTool tool;

    ViewPanel(PluginTool tool, ViewManagerComponentProvider provider) {
        this.provider = provider;
        this.tool = tool;
        this.map = new HashMap();
        this.create();
        this.createActions();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addView(ViewProviderService vp) {
        String name;
        if (!this.provider.isInTool()) {
            this.provider.addToTool();
        }
        if (this.map.remove(name = vp.getViewName()) != null) {
            this.map.put(name, vp);
            this.setCurrentView(name);
        } else {
            this.tabbedPane.removeChangeListener(this);
            try {
                int index = this.tabbedPane.indexOfTab(name);
                if (index >= 0) {
                    this.tabbedPane.remove(index);
                }
                this.map.put(name, vp);
                int insertIndex = this.tabbedPane.getTabCount();
                JComponent viewComponent = vp.getViewComponent();
                this.tabbedPane.insertTab(name, null, viewComponent, null, insertIndex);
                this.tabbedPane.setTabComponentAt(insertIndex, (Component)new DockingTabRenderer(this.tabbedPane, name, name, e -> this.closeView(this.getViewProviderForComponent(viewComponent), true)));
            }
            finally {
                this.tabbedPane.addChangeListener(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeView(ViewProviderService vps) {
        String viewName = vps.getViewName();
        this.tabbedPane.removeChangeListener(this);
        try {
            int index = this.tabbedPane.indexOfTab(viewName);
            if (index < 0) {
                throw new AssertException("Tabbed Pane does not contain " + viewName + ", but was in the view map!");
            }
            boolean tabSelected = index == this.tabbedPane.getSelectedIndex();
            this.tabbedPane.remove(index);
            this.map.remove(viewName);
            if (tabSelected) {
                this.viewChanged();
            }
        }
        finally {
            this.tabbedPane.addChangeListener(this);
        }
        return true;
    }

    AddressSetView getCurrentView() {
        ViewProviderService v = this.getCurrentViewProvider();
        if (v != null) {
            return v.getCurrentView();
        }
        return null;
    }

    boolean isTabClick(MouseEvent event) {
        Component component = event.getComponent();
        int tabCount = this.tabbedPane.getTabCount();
        for (int i = 0; i < tabCount; ++i) {
            DockingTabRenderer renderer = (DockingTabRenderer)this.tabbedPane.getTabComponentAt(i);
            if (!SwingUtilities.isDescendingFrom(component, (Component)renderer)) continue;
            return true;
        }
        return false;
    }

    boolean setCurrentView(String viewName) {
        int index;
        ViewProviderService v = this.map.get(viewName);
        if (v == null) {
            return false;
        }
        JComponent c = v.getViewComponent();
        if (this.tabbedPane.getSelectedComponent() == c) {
            this.viewChanged();
        }
        if ((index = this.tabbedPane.indexOfComponent(c)) == -1) {
            return true;
        }
        this.tabbedPane.setSelectedComponent(c);
        this.updateLocalActions(v);
        for (String key : this.map.keySet()) {
            ViewProviderService vps = this.map.get(key);
            JComponent comp = vps.getViewComponent();
            if (c == comp) continue;
            vps.setHasFocus(false);
        }
        return true;
    }

    String getCurrentViewName() {
        ViewProviderService v = this.getCurrentViewProvider();
        if (v != null) {
            return v.getViewName();
        }
        return null;
    }

    AddressSetView addToView(ProgramLocation loc) {
        ViewProviderService v = this.getCurrentViewProvider();
        if (v != null) {
            return v.addToView(loc);
        }
        return null;
    }

    ViewProviderService getCurrentViewProvider() {
        Component c = this.tabbedPane.getSelectedComponent();
        return this.getViewProviderForComponent(c);
    }

    ViewProviderService getViewProviderForComponent(Component component) {
        for (String name : this.map.keySet()) {
            ViewProviderService v = this.map.get(name);
            if (v.getViewComponent() != component) continue;
            return v;
        }
        return null;
    }

    int getNumberOfViews() {
        return this.map.size();
    }

    void dispose() {
        this.tabbedPane.removeAll();
    }

    void viewNameChanged(ViewProviderService vps, String oldName) {
        ViewProviderService s = this.map.remove(oldName);
        if (s == null) {
            return;
        }
        String viewName = vps.getViewName();
        this.map.put(viewName, vps);
        for (int i = 0; i < this.map.size(); ++i) {
            Component c = this.tabbedPane.getComponentAt(i);
            if (c != vps.getViewComponent()) continue;
            DockingTabRenderer renderer = (DockingTabRenderer)this.tabbedPane.getTabComponentAt(i);
            renderer.setTitle(viewName, viewName);
            break;
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.viewChanged();
    }

    private void createActions() {
        String owner = this.provider.getOwner();
        this.closeAction = new DockingAction("Close Tree View", owner){

            public void actionPerformed(ActionContext context) {
                ViewPanel.this.closeView(ViewPanel.this.getCurrentViewProvider(), true);
            }

            public boolean isAddToPopup(ActionContext context) {
                return context.getContextObject() instanceof ViewPanel;
            }
        };
        this.closeAction.setEnabled(true);
        this.closeAction.setPopupMenuData(new MenuData(new String[]{"Close"}, null, "TreeView"));
        this.deleteAction = new DockingAction("Delete Tree View", owner){

            public void actionPerformed(ActionContext context) {
                ViewPanel.this.deleteView();
            }

            public boolean isAddToPopup(ActionContext context) {
                return context.getContextObject() instanceof ViewPanel;
            }
        };
        this.deleteAction.setEnabled(true);
        this.deleteAction.setPopupMenuData(new MenuData(new String[]{"Delete"}, null, "TreeView"));
        this.renameAction = new DockingAction("Rename Tree View", owner){

            public void actionPerformed(ActionContext context) {
                ViewPanel.this.renameView();
            }

            public boolean isAddToPopup(ActionContext context) {
                return context.getContextObject() instanceof ViewPanel;
            }
        };
        this.renameAction.setEnabled(true);
        this.renameAction.setPopupMenuData(new MenuData(new String[]{"Rename"}, null, "TreeView"));
        this.tool.addAction((DockingActionIf)this.closeAction);
        this.tool.addAction((DockingActionIf)this.deleteAction);
        this.tool.addAction((DockingActionIf)this.renameAction);
    }

    private void create() {
        this.tabbedPane = new JTabbedPane(3, 1);
        this.tabbedPane.addChangeListener(this);
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabbedPane, "Center");
        this.setPreferredSize(new Dimension(200, 300));
    }

    private void viewChanged() {
        JComponent c = (JComponent)this.tabbedPane.getSelectedComponent();
        for (String key : this.map.keySet()) {
            ViewProviderService v = this.map.get(key);
            if (c == v.getViewComponent()) {
                v.setHasFocus(true);
                this.provider.viewChanged(v.getCurrentView());
                this.updateLocalActions(v);
                continue;
            }
            v.setHasFocus(false);
        }
        if (c == null) {
            this.updateLocalActions(null);
        }
    }

    private void updateLocalActions(ViewProviderService view) {
        if (this.localActions != null) {
            for (DockingAction localAction : this.localActions) {
                this.tool.removeLocalAction((ComponentProvider)this.provider, (DockingActionIf)localAction);
            }
            this.localActions = null;
        }
        if (view != null) {
            this.localActions = view.getToolBarActions();
            if (this.localActions != null) {
                for (DockingAction localAction : this.localActions) {
                    this.tool.addLocalAction((ComponentProvider)this.provider, (DockingActionIf)localAction);
                }
            }
        }
    }

    private void closeView(ViewProviderService vps, boolean doNotify) {
        if (vps == null) {
            return;
        }
        if (doNotify && !vps.viewClosed()) {
            return;
        }
        String viewName = vps.getViewName();
        ViewProviderService v = this.map.remove(viewName);
        if (vps == v) {
            int index = this.tabbedPane.indexOfTab(viewName);
            if (index >= 0) {
                this.tabbedPane.remove(index);
            }
        } else if (v != null) {
            this.map.put(viewName, v);
        }
        if (this.isEmpty()) {
            this.provider.removeFromTool();
        } else if (this.tabbedPane.getSelectedIndex() != 0) {
            this.tabbedPane.setSelectedIndex(0);
        }
        this.viewChanged();
        this.tool.setConfigChanged(true);
    }

    private void deleteView() {
        ViewProviderService vps = this.getCurrentViewProvider();
        if (vps != null && vps.viewDeleted()) {
            this.closeView(vps, false);
        }
    }

    private void renameView() {
        ViewProviderService vps = this.getCurrentViewProvider();
        int tabIndex = this.tabbedPane.getSelectedIndex();
        String oldName = vps.getViewName();
        Rectangle rect = this.tabbedPane.getBoundsAt(tabIndex);
        this.tool.showEditWindow(oldName, (Component)this.tabbedPane, rect, (EditListener)new RenameListener(vps, tabIndex));
    }

    private class RenameListener
    implements EditListener {
        private ViewProviderService vps;
        private int tabIndex;

        RenameListener(ViewProviderService vps, int tabIndex) {
            this.vps = vps;
            this.tabIndex = tabIndex;
        }

        public void editCompleted(String newName) {
            if (newName.length() == 0) {
                Msg.showError(this.getClass(), null, (String)"Invalid Name", (Object)"Please enter a valid name.");
                String oldName = this.vps.getViewName();
                Rectangle rect = ViewPanel.this.tabbedPane.getBoundsAt(this.tabIndex);
                ViewPanel.this.tool.showEditWindow(oldName, (Component)ViewPanel.this.tabbedPane, rect, (EditListener)this);
                return;
            }
            String oldName = this.vps.getViewName();
            if (!newName.equals(oldName) && this.vps.viewRenamed(newName)) {
                int selectedIndex = ViewPanel.this.tabbedPane.getSelectedIndex();
                ViewPanel.this.tabbedPane.setTitleAt(selectedIndex, newName);
                DockingTabRenderer renderer = (DockingTabRenderer)ViewPanel.this.tabbedPane.getTabComponentAt(selectedIndex);
                renderer.setTitle(newName, newName);
                ViewPanel.this.map.remove(oldName);
                ViewPanel.this.map.put(newName, this.vps);
            }
        }
    }
}

