/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.equate;

import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.EquateTable;

class RemoveEquateCmd
implements Command {
    private String[] equateNames;
    private String msg;
    private PluginTool tool;

    RemoveEquateCmd(String equateName, PluginTool tool) {
        this.equateNames = new String[]{equateName};
        this.tool = tool;
    }

    RemoveEquateCmd(String[] equateNames, PluginTool tool) {
        this.equateNames = equateNames;
        this.tool = tool;
    }

    public String getName() {
        return "Remove Equate" + (this.equateNames.length > 1 ? "s" : "");
    }

    public boolean applyTo(DomainObject obj) {
        EquateTable etable = ((Program)obj).getEquateTable();
        boolean success = true;
        for (int i = 0; i < this.equateNames.length; ++i) {
            String name = this.equateNames[i];
            if (etable.removeEquate(name)) continue;
            this.tool.setStatusInfo("Unable to remove equate: " + name);
            success = false;
        }
        if (!success) {
            this.msg = "Failed to remove one or more equates";
        }
        return success;
    }

    public String getStatusMsg() {
        return this.msg;
    }
}

