/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr;

import docking.widgets.label.GDHtmlLabel;
import ghidra.app.util.ToolTipUtils;
import ghidra.app.util.html.HTMLDataTypeRepresentation;
import ghidra.program.model.data.DataType;
import ghidra.util.HTMLUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class DataTypeComparePanel
extends JPanel {
    private JLabel dtLabel1;
    private JLabel dtLabel2;
    private JPanel leftPanel;
    private JPanel rightPanel;
    private JLabel leftPanelLabel;
    private JLabel rightPanelLabel;
    private String clientName;
    private String sourceName;

    DataTypeComparePanel(String clientName, String sourceName) {
        super(new GridLayout(0, 2));
        this.clientName = clientName;
        this.sourceName = sourceName;
        this.init();
    }

    private void init() {
        this.setPreferredSize(new Dimension(500, 200));
        this.leftPanel = new JPanel(new BorderLayout());
        this.rightPanel = new JPanel(new BorderLayout());
        this.leftPanelLabel = new GDHtmlLabel();
        this.rightPanelLabel = new GDHtmlLabel();
        this.leftPanelLabel.setBorder(BorderFactory.createEmptyBorder(2, 8, 2, 0));
        this.rightPanelLabel.setBorder(BorderFactory.createEmptyBorder(2, 8, 2, 0));
        this.setLabelText(this.leftPanelLabel, HTMLUtilities.escapeHTML((String)this.clientName) + ":");
        this.setLabelText(this.rightPanelLabel, HTMLUtilities.escapeHTML((String)this.sourceName) + ":");
        this.add(this.leftPanel);
        this.add(this.rightPanel);
        this.dtLabel1 = new GDHtmlLabel();
        this.dtLabel1.setOpaque(true);
        this.dtLabel1.setBackground(Color.WHITE);
        this.dtLabel1.setBorder(BorderFactory.createEmptyBorder(2, 8, 0, 0));
        this.dtLabel1.setVerticalAlignment(1);
        this.dtLabel2 = new GDHtmlLabel();
        this.dtLabel2.setOpaque(true);
        this.dtLabel2.setBackground(Color.WHITE);
        this.dtLabel2.setBorder(BorderFactory.createEmptyBorder(2, 8, 0, 0));
        this.dtLabel2.setVerticalAlignment(1);
        JScrollPane leftScrollPane = new JScrollPane(this.dtLabel1);
        JScrollPane rightScrollPane = new JScrollPane(this.dtLabel2);
        leftScrollPane.getVerticalScrollBar().setUnitIncrement(9);
        rightScrollPane.getVerticalScrollBar().setUnitIncrement(9);
        this.leftPanel.add(leftScrollPane);
        this.rightPanel.add(rightScrollPane);
        this.leftPanel.add((Component)this.leftPanelLabel, "North");
        this.rightPanel.add((Component)this.rightPanelLabel, "North");
        this.syncScrollers(leftScrollPane, rightScrollPane);
    }

    private void syncScrollers(JScrollPane leftScrollPane, JScrollPane rightScrollPane) {
        final JViewport viewport1 = leftScrollPane.getViewport();
        final JViewport viewport2 = rightScrollPane.getViewport();
        viewport1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int y = viewport1.getViewPosition().y;
                viewport2.setViewPosition(new Point(0, y));
            }
        });
        viewport2.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int y = viewport2.getViewPosition().y;
                viewport1.setViewPosition(new Point(0, y));
            }
        });
    }

    void setDataTypes(DataType dataType1, DataType dataType2) {
        String dt1Text;
        String path1 = dataType1 != null ? dataType1.getPathName() : "";
        String path2 = dataType2 != null ? dataType2.getPathName() : "";
        this.setLabelText(this.leftPanelLabel, this.clientName + ": " + path1);
        this.setLabelText(this.rightPanelLabel, this.sourceName + ": " + path2);
        HTMLDataTypeRepresentation representation1 = ToolTipUtils.getHTMLRepresentation(dataType1);
        HTMLDataTypeRepresentation representation2 = ToolTipUtils.getHTMLRepresentation(dataType2);
        HTMLDataTypeRepresentation[] diffs = representation1.diff(representation2);
        String string = dt1Text = dataType1 != null ? diffs[0].getHTMLString() : "";
        String dt2Text = dataType2 != null ? diffs[1].getHTMLString() : (dataType1 != null ? "<Removed>" : "");
        this.dtLabel1.setText(dt1Text);
        this.dtLabel2.setText(dt2Text);
    }

    private void setLabelText(JLabel label, String text) {
        label.setText(HTMLUtilities.wrapAsHTML((String)HTMLUtilities.bold((String)text)));
    }
}

