/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.data;

import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.cmd.data.CreateStructureCmd;
import ghidra.app.cmd.data.CreateStructureInStructureCmd;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.ListingContextAction;
import ghidra.app.plugin.core.data.CreateStructureDialog;
import ghidra.app.plugin.core.data.DataPlugin;
import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.StructureFactory;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.util.InteriorSelection;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;

class CreateStructureAction
extends ListingContextAction {
    private static final String[] CREATE_STRUCTURE_POPUP_MENU = new String[]{"Data", "Create Structure..."};
    private DataPlugin plugin;
    private CreateStructureDialog createStructureDialog;

    public CreateStructureAction(DataPlugin plugin) {
        super("Create Structure", plugin.getName());
        this.setPopupMenuData(new MenuData(CREATE_STRUCTURE_POPUP_MENU, null, "BasicData"));
        this.setKeyBindingData(new KeyBindingData(91, 64));
        this.plugin = plugin;
        this.setEnabled(true);
        this.createStructureDialog = new CreateStructureDialog(plugin.getTool());
    }

    public void dispose() {
        super.dispose();
        this.createStructureDialog.dispose();
    }

    @Override
    public void actionPerformed(ListingActionContext programActionContext) {
        Program program = programActionContext.getProgram();
        ProgramSelection sel = programActionContext.getSelection();
        if (sel != null && !sel.isEmpty()) {
            InteriorSelection interiorSel = sel.getInteriorSelection();
            if (interiorSel != null) {
                this.createStructureInStructure(program, interiorSel);
            } else {
                this.createStructureInProgram(program, sel);
            }
        }
    }

    private void createStructureInStructure(Program program, InteriorSelection sel) {
        PluginTool tool = this.plugin.getTool();
        ProgramLocation from = sel.getFrom();
        ProgramLocation to = sel.getTo();
        Data data = program.getListing().getDataContaining(from.getAddress());
        Data comp = null;
        if (data != null) {
            comp = data.getComponent(from.getComponentPath());
        }
        if (comp == null) {
            tool.setStatusInfo("Create Structure Failed! No data at " + from.getAddress());
            return;
        }
        DataType parentDataType = comp.getParent().getBaseDataType();
        if (!(parentDataType instanceof Structure)) {
            tool.setStatusInfo("Cannot create structure here");
            return;
        }
        Address newStructureAddress = from.getAddress();
        int[] fromPath = from.getComponentPath();
        int[] toPath = to.getComponentPath();
        Structure tempStructure = null;
        try {
            tempStructure = StructureFactory.createStructureDataTypeInStrucuture((Program)program, (Address)newStructureAddress, (int[])fromPath, (int[])toPath);
        }
        catch (Exception exc) {
            tool.setStatusInfo("Create structure failed: " + exc.getMessage());
            return;
        }
        Structure userChoice = this.createStructureDialog.showCreateStructureDialog(program, tempStructure);
        if (userChoice != null) {
            CreateStructureInStructureCmd cmd = new CreateStructureInStructureCmd(userChoice, newStructureAddress, fromPath, toPath);
            if (!tool.execute((Command)cmd, (DomainObject)program)) {
                tool.setStatusInfo(cmd.getStatusMsg());
            } else {
                this.plugin.updateRecentlyUsed(cmd.getNewDataType());
            }
        }
    }

    private void createStructureInProgram(Program program, ProgramSelection sel) {
        PluginTool tool = this.plugin.getTool();
        if (sel.getNumAddressRanges() > 1) {
            tool.setStatusInfo("Can only create structure on contiguous selection");
            return;
        }
        if (sel.getNumAddresses() > Integer.MAX_VALUE) {
            tool.setStatusInfo("Can't create structures greater than 0x7fffffff bytes");
            return;
        }
        Data data = program.getListing().getDataContaining(sel.getMinAddress());
        if (data == null) {
            tool.setStatusInfo("Create structure failed! No data at " + sel.getMinAddress());
            return;
        }
        Address structureAddress = sel.getMinAddress();
        int structureLength = (int)sel.getNumAddresses();
        Structure tempStructure = null;
        try {
            tempStructure = StructureFactory.createStructureDataType((Program)program, (Address)structureAddress, (int)structureLength);
        }
        catch (Exception exc) {
            tool.setStatusInfo("Create structure failed: " + exc.getMessage());
            return;
        }
        Structure userChoice = this.createStructureDialog.showCreateStructureDialog(program, tempStructure);
        if (userChoice != null) {
            CreateStructureCmd cmd = new CreateStructureCmd(userChoice, structureAddress);
            if (!tool.execute((Command)cmd, (DomainObject)program)) {
                tool.setStatusInfo(cmd.getStatusMsg());
            } else {
                this.plugin.updateRecentlyUsed(cmd.getNewDataType());
            }
        }
    }

    @Override
    public boolean isEnabledForContext(ListingActionContext context) {
        ProgramSelection sel = context.getSelection();
        if (sel != null && !sel.isEmpty()) {
            return this.plugin.isCreateDataAllowed(context);
        }
        return false;
    }
}

