/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.refs;

import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;

public class AddShiftedMemRefCmd
implements Command {
    private Address fromAddr;
    private Address toAddr;
    private RefType refType;
    private SourceType source;
    private int opIndex;
    private int shift;

    public AddShiftedMemRefCmd(Address fromAddr, Address toAddr, RefType refType, SourceType source, int opIndex, int shift) {
        this.fromAddr = fromAddr;
        this.toAddr = toAddr;
        this.refType = refType;
        this.source = source;
        this.opIndex = opIndex;
        this.shift = shift;
    }

    public boolean applyTo(DomainObject obj) {
        Program p = (Program)obj;
        ReferenceManager refMgr = p.getReferenceManager();
        refMgr.addShiftedMemReference(this.fromAddr, this.toAddr, this.shift, this.refType, this.source, this.opIndex);
        return true;
    }

    public String getStatusMsg() {
        return "";
    }

    public String getName() {
        return "Add Shifted Memory Reference";
    }
}

