/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.refs;

import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;

public class AddExternalNameCmd
implements Command {
    private String name;
    private SourceType source;
    private String status;

    public AddExternalNameCmd(String name, SourceType source) {
        this.name = name;
        this.source = source;
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("name is invalid: " + name);
        }
    }

    public boolean applyTo(DomainObject obj) {
        Program program = (Program)obj;
        try {
            program.getExternalManager().addExternalLibraryName(this.name, this.source);
            return true;
        }
        catch (DuplicateNameException e) {
            this.status = this.name + " already exists";
        }
        catch (InvalidInputException e) {
            this.status = e.getMessage();
        }
        return false;
    }

    public String getStatusMsg() {
        return this.status;
    }

    public String getName() {
        return "Add External Program Name";
    }
}

