/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.function;

import ghidra.app.cmd.disassemble.DisassembleCommand;
import ghidra.app.cmd.function.ApplyFunctionSignatureCmd;
import ghidra.app.cmd.function.CreateFunctionCmd;
import ghidra.app.util.PseudoDisassembler;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionSignature;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.Msg;
import ghidra.util.task.TaskMonitor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ApplyFunctionDataTypesCmd
extends BackgroundCommand {
    private Program program;
    private BookmarkManager bookmarkMgr;
    private List<DataTypeManager> managers;
    private AddressSetView addresses;
    private SourceType source;
    private boolean alwaysReplace;
    private boolean createBookmarksEnabled;
    private Map<String, FunctionDefinition> functionNameMap = new HashMap<String, FunctionDefinition>();

    public ApplyFunctionDataTypesCmd(List<DataTypeManager> managers, AddressSetView set, SourceType source, boolean alwaysReplace, boolean createBookmarksEnabled) {
        super("Apply Function Data Types", true, false, false);
        this.managers = managers;
        this.addresses = set;
        this.source = source;
        this.alwaysReplace = alwaysReplace;
        this.createBookmarksEnabled = createBookmarksEnabled;
    }

    public boolean applyTo(DomainObject obj, TaskMonitor monitor) {
        this.program = (Program)obj;
        this.bookmarkMgr = this.program.getBookmarkManager();
        monitor.setMessage("Applying Function Signatures");
        Map<String, List<Symbol>> symbolMap = this.createSymMap();
        this.applyDataTypes(monitor, symbolMap);
        return true;
    }

    private Map<String, List<Symbol>> createSymMap() {
        HashMap<String, List<Symbol>> symbolMap = new HashMap<String, List<Symbol>>();
        SymbolTable symbolTable = this.program.getSymbolTable();
        if (this.addresses == null) {
            this.getSymbols(symbolMap, symbolTable.getSymbolIterator());
            this.getSymbols(symbolMap, symbolTable.getExternalSymbols());
        } else {
            this.getSymbols(symbolMap, symbolTable.getSymbols(this.addresses, SymbolType.FUNCTION, true));
            this.getSymbols(symbolMap, symbolTable.getSymbols(this.addresses, SymbolType.LABEL, true));
        }
        return symbolMap;
    }

    private void getSymbols(Map<String, List<Symbol>> symbolMap, SymbolIterator symbols) {
        while (symbols.hasNext()) {
            Symbol sym = symbols.next();
            if (sym.isDynamic() || !sym.isExternal() && this.addresses != null && !this.addresses.contains(sym.getAddress())) continue;
            String name = this.getValidName(sym.getName());
            List<Symbol> list = symbolMap.get(name);
            if (list == null) {
                list = new LinkedList<Symbol>();
                symbolMap.put(name, list);
            }
            list.add(sym);
        }
    }

    private String getValidName(String name) {
        int pos;
        for (pos = name.length() - 1; pos >= 0 && Character.isJavaIdentifierPart(name.charAt(pos)); --pos) {
        }
        String val = name.substring(pos + 1, name.length());
        return val;
    }

    private void applyDataTypes(TaskMonitor monitor, Map<String, List<Symbol>> symbolMap) {
        for (DataTypeManager dataTypeManager : this.managers) {
            Iterator iter = dataTypeManager.getAllDataTypes();
            while (iter.hasNext()) {
                if (monitor.isCancelled()) {
                    return;
                }
                DataType dt = (DataType)iter.next();
                if (!(dt instanceof FunctionDefinition)) continue;
                FunctionDefinition fdef = (FunctionDefinition)dt;
                String name = fdef.getName();
                if (this.functionNameMap.containsKey(name)) {
                    FunctionDefinition dupeFdef = this.functionNameMap.get(name);
                    if (fdef.isEquivalent((DataType)dupeFdef)) continue;
                    this.functionNameMap.put(name, null);
                    continue;
                }
                this.functionNameMap.put(name, fdef);
            }
        }
        monitor.initialize((long)this.functionNameMap.size());
        for (String functionName : this.functionNameMap.keySet()) {
            FunctionDefinition fdef = this.functionNameMap.get(functionName);
            this.checkForSymbol(monitor, functionName, fdef, symbolMap, null);
            this.checkForSymbol(monitor, functionName, fdef, symbolMap, "thunk");
            monitor.incrementProgress(1L);
        }
    }

    private void checkForSymbol(TaskMonitor monitor, String functionName, FunctionDefinition fdef, Map<String, List<Symbol>> symbolMap, String prefix) {
        List<Symbol> symbols = this.lookupSymbol(symbolMap, prefix, functionName);
        if (symbols == null) {
            return;
        }
        for (Symbol symbol : symbols) {
            this.checkDoApplyFunctionDefinition(monitor, functionName, fdef, symbol);
        }
    }

    private void checkDoApplyFunctionDefinition(TaskMonitor monitor, String functionName, FunctionDefinition fdef, Symbol sym) {
        PseudoDisassembler pdis;
        monitor.setMessage("Apply Function Signature '" + functionName + "'");
        Address address = sym.getAddress();
        Function func = this.program.getFunctionManager().getFunctionAt(address);
        if (func != null) {
            if (func.isThunk() || func.getSignature(true).equals(fdef)) {
                return;
            }
            SourceType mostTrusted = this.getMostTrustedParameterSource(func);
            if (this.alwaysReplace || !this.source.isLowerPriorityThan(mostTrusted)) {
                this.applyFunction(sym, fdef);
            }
            return;
        }
        func = this.program.getFunctionManager().getFunctionContaining(address);
        if (func != null) {
            return;
        }
        if (!this.isValidFunctionStart(monitor, address)) {
            return;
        }
        CreateFunctionCmd functionCmd = new CreateFunctionCmd(address);
        Listing listing = this.program.getListing();
        if (sym.isExternal() || listing.getInstructionAt(address) != null) {
            functionCmd.applyTo((DomainObject)this.program);
            this.applyFunction(sym, fdef);
            return;
        }
        MemoryBlock block = this.program.getMemory().getBlock(address);
        if (block != null && !block.isInitialized()) {
            return;
        }
        if (listing.getUndefinedDataAt(address) != null && (pdis = new PseudoDisassembler(this.program)).isValidSubroutine(address)) {
            DisassembleCommand disassembleCmd = new DisassembleCommand(address, null, true);
            disassembleCmd.applyTo((DomainObject)this.program);
            functionCmd.applyTo((DomainObject)this.program);
            this.applyFunction(sym, fdef);
        }
    }

    boolean isValidFunctionStart(TaskMonitor monitor, Address address) {
        Instruction instructionBefore = this.program.getListing().getInstructionContaining(address.subtract(1L));
        if (instructionBefore != null && address.equals((Object)instructionBefore.getFallThrough())) {
            return false;
        }
        ReferenceIterator referencesTo = this.program.getReferenceManager().getReferencesTo(address);
        for (Reference reference : referencesTo) {
            RefType referenceType = reference.getReferenceType();
            if (referenceType.isCall() || !referenceType.isJump()) continue;
            return false;
        }
        return true;
    }

    private void applyFunction(Symbol sym, FunctionDefinition fdef) {
        if (fdef == null) {
            Msg.info((Object)((Object)this), (Object)("Multiple function definitions for " + sym.getName() + " at " + sym.getAddress() + " found.  No function signature applied."));
            if (this.createBookmarksEnabled) {
                this.bookmarkMgr.setBookmark(sym.getAddress(), "Analysis", "Multiple Function Signatures", "Found multiple function definitions for: " + sym.getName());
            }
            return;
        }
        ApplyFunctionSignatureCmd fsigCmd = new ApplyFunctionSignatureCmd(sym.getAddress(), (FunctionSignature)fdef, this.source);
        fsigCmd.applyTo((DomainObject)this.program);
    }

    private SourceType getMostTrustedParameterSource(Function func) {
        Parameter[] parameters;
        SourceType highestSource = SourceType.DEFAULT;
        for (Parameter parameter : parameters = func.getParameters()) {
            SourceType paramSource = parameter.getSource();
            if (!paramSource.isHigherPriorityThan(highestSource)) continue;
            highestSource = paramSource;
        }
        return highestSource;
    }

    private List<Symbol> lookupSymbol(Map<String, List<Symbol>> symbolMap, String prefix, String functionName) {
        List<Symbol> symbols;
        if (functionName == null || functionName.length() == 0) {
            return null;
        }
        Object loolupName = functionName;
        if (prefix != null) {
            loolupName = prefix + functionName;
        }
        if ((symbols = symbolMap.get(loolupName)) != null) {
            return symbols;
        }
        symbols = symbolMap.get("_" + (String)loolupName);
        return symbols;
    }
}

