/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util;

import generic.concurrent.ConcurrentQ;
import generic.concurrent.ConcurrentQBuilder;
import generic.concurrent.GThreadPool;
import generic.concurrent.QCallback;
import generic.concurrent.QResult;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.util.Msg;
import ghidra.util.task.TaskMonitor;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;

public class DecompilerConcurrentQ<I, R> {
    private ConcurrentQ<I, R> queue;

    public DecompilerConcurrentQ(QCallback<I, R> callback, TaskMonitor monitor) {
        this(callback, AutoAnalysisManager.getSharedAnalsysThreadPool(), monitor);
    }

    public DecompilerConcurrentQ(QCallback<I, R> callback, String threadPoolName, TaskMonitor monitor) {
        this(callback, GThreadPool.getSharedThreadPool((String)threadPoolName), monitor);
    }

    private DecompilerConcurrentQ(QCallback<I, R> callback, GThreadPool pool, TaskMonitor monitor) {
        this.queue = new ConcurrentQBuilder().setCollectResults(true).setThreadPool(pool).setMonitor(monitor).build(callback);
    }

    public void addAll(Collection<I> collection) {
        this.queue.add(collection);
    }

    public void addAll(Iterator<I> iterator) {
        this.queue.add(iterator);
    }

    public void add(I i) {
        this.queue.add(i);
    }

    public Collection<QResult<I, R>> waitForResults() throws InterruptedException {
        Collection results = null;
        try {
            results = this.queue.waitForResults();
        }
        finally {
            this.queue.dispose();
        }
        return results;
    }

    public void waitUntilDone() throws InterruptedException, Exception {
        this.queue.waitUntilDone();
    }

    public void dispose() {
        this.queue.dispose();
    }

    public void dispose(long timeoutSeconds) {
        this.queue.dispose();
        boolean finished = false;
        try {
            finished = this.queue.waitUntilDone(timeoutSeconds, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!finished) {
            Msg.debug((Object)this, (Object)("Unable to shutdown all tasks in " + timeoutSeconds + " " + TimeUnit.SECONDS));
        }
    }
}

