/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.program.model.data.Array;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.data.Union;
import ghidra.util.Msg;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;

public abstract class DataTypeConflictHandler {
    public static final DataTypeConflictHandler DEFAULT_HANDLER = new DataTypeConflictHandler(){

        @Override
        public ConflictResult resolveConflict(DataType addedDataType, DataType existingDataType) {
            Msg.info((Object)this, (Object)("Conflict with existing type " + existingDataType.getName() + "(" + existingDataType.getDescription() + "), new type will be renamed with .conflict suffix"));
            return ConflictResult.RENAME_AND_ADD;
        }

        @Override
        public boolean shouldUpdate(DataType sourceDataType, DataType localDataType) {
            return true;
        }

        @Override
        public DataTypeConflictHandler getSubsequentHandler() {
            return DEFAULT_SUBSEQUENT_HANDLER;
        }
    };
    private static final DataTypeConflictHandler DEFAULT_SUBSEQUENT_HANDLER = new DataTypeConflictHandler(){

        @Override
        public ConflictResult resolveConflict(DataType addedDataType, DataType existingDataType) {
            return DEFAULT_HANDLER.resolveConflict(addedDataType, existingDataType);
        }

        @Override
        public boolean shouldUpdate(DataType sourceDataType, DataType localDataType) {
            return false;
        }

        @Override
        public DataTypeConflictHandler getSubsequentHandler() {
            return this;
        }
    };
    public static DataTypeConflictHandler REPLACE_HANDLER = new DataTypeConflictHandler(){

        @Override
        public ConflictResult resolveConflict(DataType addedDataType, DataType existingDataType) {
            return ConflictResult.REPLACE_EXISTING;
        }

        @Override
        public boolean shouldUpdate(DataType sourceDataType, DataType localDataType) {
            return true;
        }

        @Override
        public DataTypeConflictHandler getSubsequentHandler() {
            return SUBSEQUENT_REPLACE_HANDLER;
        }
    };
    private static final DataTypeConflictHandler SUBSEQUENT_REPLACE_HANDLER = new DataTypeConflictHandler(){

        @Override
        public ConflictResult resolveConflict(DataType addedDataType, DataType existingDataType) {
            return REPLACE_HANDLER.resolveConflict(addedDataType, existingDataType);
        }

        @Override
        public boolean shouldUpdate(DataType sourceDataType, DataType localDataType) {
            return false;
        }

        @Override
        public DataTypeConflictHandler getSubsequentHandler() {
            return this;
        }
    };
    public static final DataTypeConflictHandler KEEP_HANDLER = new DataTypeConflictHandler(){

        @Override
        public ConflictResult resolveConflict(DataType addedDataType, DataType existingDataType) {
            Msg.info((Object)this, (Object)("New type not added in favor of existing type " + existingDataType.getName() + "(" + existingDataType.getDescription() + ")"));
            return ConflictResult.USE_EXISTING;
        }

        @Override
        public boolean shouldUpdate(DataType sourceDataType, DataType localDataType) {
            return false;
        }

        @Override
        public DataTypeConflictHandler getSubsequentHandler() {
            return this;
        }
    };
    public static final DataTypeConflictHandler REPLACE_EMPTY_STRUCTS_OR_RENAME_AND_ADD_HANDLER = new DataTypeConflictHandler(){

        private boolean isSizeCompatible(Composite src, Composite target) {
            return target.getLength() <= 1 || src.getLength() == target.getLength();
        }

        private boolean isCompositeEmpty(Composite composite) {
            return composite.getLength() <= 1 && composite.getNumComponents() == 0;
        }

        private boolean isCompositeDefault(Composite composite) {
            if (composite.getLength() == composite.getNumComponents()) {
                DataTypeComponent[] comps = composite.getComponents();
                boolean isDefault = true;
                for (int i = 0; i < comps.length; ++i) {
                    if (comps[i].getDataType() == DataType.DEFAULT) continue;
                    isDefault = false;
                    break;
                }
                if (isDefault) {
                    return true;
                }
            }
            return false;
        }

        private boolean isCompositePart(Composite full, Composite part, Map<DataType, DataType> visitedDataTypes) {
            if (full instanceof Structure && part instanceof Structure) {
                return this.isStructurePart((Structure)full, (Structure)part, visitedDataTypes);
            }
            if (full instanceof Union && part instanceof Union) {
                return this.isUnionPart((Union)full, (Union)part, visitedDataTypes);
            }
            return false;
        }

        private boolean isUnionPart(Union full, Union part, Map<DataType, DataType> visitedDataTypes) {
            String name;
            if (full.getLength() < part.getLength()) {
                return false;
            }
            HashMap<String, DataTypeComponent> fullComponentsByName = new HashMap<String, DataTypeComponent>();
            for (DataTypeComponent dtc : full.getComponents()) {
                name = dtc.getFieldName();
                if (name == null) {
                    name = dtc.getDefaultFieldName();
                }
                fullComponentsByName.put(name, dtc);
            }
            for (DataTypeComponent dtc : part.getComponents()) {
                DataType fullDT;
                DataTypeComponent fullDTC;
                name = dtc.getFieldName();
                if (name == null) {
                    name = dtc.getDefaultFieldName();
                }
                if ((fullDTC = (DataTypeComponent)fullComponentsByName.get(name)) == null) {
                    return false;
                }
                DataType partDT = dtc.getDataType();
                if (this.doRelaxedCompare(partDT, fullDT = fullDTC.getDataType(), visitedDataTypes) != ConflictResult.RENAME_AND_ADD) continue;
                return false;
            }
            return true;
        }

        private boolean isStructurePart(Structure full, Structure part, Map<DataType, DataType> visitedDataTypes) {
            if (full.getLength() != part.getLength()) {
                return false;
            }
            boolean[] fullCompsUsedFlag = new boolean[full.getComponents().length];
            DataTypeComponent[] partComps = part.getDefinedComponents();
            for (int i = 0; i < partComps.length; ++i) {
                DataType fullDT;
                DataTypeComponent partDTC = partComps[i];
                DataTypeComponent fullDTCAt = full.getComponentAt(partDTC.getOffset());
                int fullOrd = fullDTCAt.getOrdinal();
                if (fullCompsUsedFlag[fullOrd]) {
                    return false;
                }
                DataType partDT = partDTC.getDataType();
                if (this.doRelaxedCompare(partDT, fullDT = fullDTCAt.getDataType(), visitedDataTypes) == ConflictResult.RENAME_AND_ADD) {
                    return false;
                }
                fullCompsUsedFlag[fullOrd] = true;
            }
            return true;
        }

        private ConflictResult doStrictCompare(DataType addedDataType, DataType existingDataType, Map<DataType, DataType> visitedDataTypes) {
            visitedDataTypes.put(existingDataType, addedDataType);
            if (existingDataType.isEquivalent(addedDataType)) {
                return ConflictResult.USE_EXISTING;
            }
            if (existingDataType instanceof Composite && addedDataType instanceof Composite) {
                Composite existingComposite = (Composite)existingDataType;
                Composite addedComposite = (Composite)addedDataType;
                if ((this.isCompositeEmpty(addedComposite) || this.isCompositeDefault(addedComposite)) && this.isSizeCompatible(existingComposite, addedComposite)) {
                    return ConflictResult.USE_EXISTING;
                }
                if ((this.isCompositeEmpty(existingComposite) || this.isCompositeDefault(existingComposite)) && this.isSizeCompatible(addedComposite, existingComposite)) {
                    return ConflictResult.REPLACE_EXISTING;
                }
                if (this.isCompositePart(existingComposite, addedComposite, visitedDataTypes)) {
                    return ConflictResult.USE_EXISTING;
                }
                if (this.isCompositePart(addedComposite, existingComposite, visitedDataTypes)) {
                    return ConflictResult.REPLACE_EXISTING;
                }
            } else {
                if (existingDataType instanceof TypeDef && addedDataType instanceof TypeDef) {
                    TypeDef addedTypeDef = (TypeDef)addedDataType;
                    TypeDef existingTypeDef = (TypeDef)existingDataType;
                    return this.doRelaxedCompare(addedTypeDef.getBaseDataType(), existingTypeDef.getBaseDataType(), visitedDataTypes);
                }
                if (existingDataType instanceof Array && addedDataType instanceof Array) {
                    Array addedArray = (Array)addedDataType;
                    Array existingArray = (Array)existingDataType;
                    if (addedArray.getNumElements() != existingArray.getNumElements() || addedArray.getElementLength() != existingArray.getElementLength()) {
                        return ConflictResult.RENAME_AND_ADD;
                    }
                    return this.doRelaxedCompare(addedArray.getDataType(), existingArray.getDataType(), visitedDataTypes);
                }
            }
            return ConflictResult.RENAME_AND_ADD;
        }

        private ConflictResult doRelaxedCompare(DataType addedDataType, DataType existingDataType, Map<DataType, DataType> visitedDataTypes) {
            if (existingDataType instanceof Pointer && addedDataType instanceof Pointer) {
                DataType ptrAddedDataType = ((Pointer)addedDataType).getDataType();
                DataType ptrExistingDataType = ((Pointer)existingDataType).getDataType();
                if (!visitedDataTypes.containsKey(ptrExistingDataType)) {
                    visitedDataTypes.put(ptrExistingDataType, ptrAddedDataType);
                    addedDataType = ptrAddedDataType;
                    existingDataType = ptrExistingDataType;
                }
            }
            if (addedDataType instanceof TypeDef) {
                addedDataType = ((TypeDef)addedDataType).getBaseDataType();
            }
            if (existingDataType instanceof TypeDef) {
                existingDataType = ((TypeDef)existingDataType).getBaseDataType();
            }
            return this.doStrictCompare(addedDataType, existingDataType, visitedDataTypes);
        }

        @Override
        public ConflictResult resolveConflict(DataType addedDataType, DataType existingDataType) {
            IdentityHashMap<DataType, DataType> visitedDataTypes = new IdentityHashMap<DataType, DataType>();
            return this.doStrictCompare(addedDataType, existingDataType, visitedDataTypes);
        }

        @Override
        public boolean shouldUpdate(DataType sourceDataType, DataType localDataType) {
            return false;
        }

        @Override
        public DataTypeConflictHandler getSubsequentHandler() {
            return this;
        }
    };
    static final DataTypeConflictHandler BUILT_IN_MANAGER_HANDLER = new DataTypeConflictHandler(){

        @Override
        public ConflictResult resolveConflict(DataType addedDataType, DataType existingDataType) {
            throw new UnsupportedOperationException("Built-in data-types may not be substantially changed while Ghidra is running");
        }

        @Override
        public boolean shouldUpdate(DataType sourceDataType, DataType localDataType) {
            return false;
        }

        @Override
        public DataTypeConflictHandler getSubsequentHandler() {
            return this;
        }
    };

    private DataTypeConflictHandler() {
    }

    public abstract ConflictResult resolveConflict(DataType var1, DataType var2);

    public abstract boolean shouldUpdate(DataType var1, DataType var2);

    public abstract DataTypeConflictHandler getSubsequentHandler();

    public static enum ConflictResult {
        RENAME_AND_ADD,
        USE_EXISTING,
        REPLACE_EXISTING;

    }

    public static enum ConflictResolutionPolicy {
        RENAME_AND_ADD{

            @Override
            public DataTypeConflictHandler getHandler() {
                return DEFAULT_HANDLER;
            }
        }
        ,
        USE_EXISTING{

            @Override
            public DataTypeConflictHandler getHandler() {
                return KEEP_HANDLER;
            }
        }
        ,
        REPLACE_EXISTING{

            @Override
            public DataTypeConflictHandler getHandler() {
                return REPLACE_HANDLER;
            }
        }
        ,
        REPLACE_EMPTY_STRUCTS_OR_RENAME_AND_ADD{

            @Override
            public DataTypeConflictHandler getHandler() {
                return REPLACE_EMPTY_STRUCTS_OR_RENAME_AND_ADD_HANDLER;
            }
        };


        public abstract DataTypeConflictHandler getHandler();
    }
}

