/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.app.plugin.core.datamgr.archive.SourceArchive;
import ghidra.docking.settings.Settings;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.data.DataOrganizationImpl;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeDisplayOptions;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataTypePath;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.mem.MemBuffer;
import ghidra.util.InvalidNameException;
import ghidra.util.UniversalID;
import ghidra.util.exception.DuplicateNameException;
import java.net.URL;

public abstract class AbstractDataType
implements DataType {
    protected String name;
    protected CategoryPath categoryPath;
    protected final DataTypeManager dataMgr;
    private DataOrganization dataOrganization;

    protected AbstractDataType(CategoryPath path, String name, DataTypeManager dataTypeManager) {
        if (path == null) {
            throw new IllegalArgumentException("Category Path is null!");
        }
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Name is null or empty!");
        }
        if (!DataUtilities.isValidDataTypeName(name)) {
            throw new IllegalArgumentException("Invalid DataType name: " + name);
        }
        this.categoryPath = path;
        this.name = name;
        this.dataMgr = dataTypeManager;
    }

    @Override
    public CategoryPath getCategoryPath() {
        return this.categoryPath;
    }

    @Override
    public final DataTypeManager getDataTypeManager() {
        return this.dataMgr;
    }

    @Override
    public final DataOrganization getDataOrganization() {
        if (this.dataOrganization != null) {
            return this.dataOrganization;
        }
        if (this.dataMgr != null) {
            this.dataOrganization = this.dataMgr.getDataOrganization();
        }
        if (this.dataOrganization == null) {
            this.dataOrganization = DataOrganizationImpl.getDefaultOrganization();
        }
        return this.dataOrganization;
    }

    @Override
    public DataTypePath getDataTypePath() {
        return new DataTypePath(this.categoryPath, this.name);
    }

    @Override
    public URL getDocs() {
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPathName() {
        return this.getDataTypePath().getPath();
    }

    @Override
    public String getDisplayName() {
        return this.getName();
    }

    @Override
    public String getMnemonic(Settings settings) {
        return this.name;
    }

    @Override
    public boolean isNotYetDefined() {
        return false;
    }

    public String toString() {
        return this.getDisplayName();
    }

    @Override
    public boolean isDeleted() {
        return false;
    }

    @Override
    public void setName(String name) throws InvalidNameException {
    }

    @Override
    public void setNameAndCategory(CategoryPath path, String name) throws InvalidNameException, DuplicateNameException {
    }

    @Override
    public void dataTypeSizeChanged(DataType dt) {
    }

    @Override
    public void dataTypeDeleted(DataType dt) {
    }

    @Override
    public void dataTypeReplaced(DataType oldDt, DataType newDt) {
    }

    @Override
    public void addParent(DataType dt) {
    }

    @Override
    public void removeParent(DataType dt) {
    }

    @Override
    public DataType[] getParents() {
        return null;
    }

    @Override
    public boolean dependsOn(DataType dt) {
        return false;
    }

    @Override
    public SourceArchive getSourceArchive() {
        return null;
    }

    @Override
    public void setSourceArchive(SourceArchive archive) {
    }

    @Override
    public long getLastChangeTime() {
        return 0L;
    }

    @Override
    public long getLastChangeTimeInSourceArchive() {
        return 0L;
    }

    @Override
    public UniversalID getUniversalID() {
        return null;
    }

    @Override
    public void dataTypeNameChanged(DataType dt, String oldName) {
    }

    @Override
    public void replaceWith(DataType dataType) {
    }

    @Override
    public void setLastChangeTime(long lastChangeTime) {
    }

    @Override
    public void setLastChangeTimeInSourceArchive(long lastChangeTimeInSourceArchive) {
    }

    @Override
    public void setDescription(String description) throws UnsupportedOperationException {
    }

    @Override
    public boolean isDynamicallySized() {
        return false;
    }

    @Override
    public String getDefaultLabelPrefix() {
        return null;
    }

    @Override
    public String getDefaultAbbreviatedLabelPrefix() {
        return this.getDefaultLabelPrefix();
    }

    @Override
    public void setCategoryPath(CategoryPath path) throws DuplicateNameException {
    }

    @Override
    public String getDefaultLabelPrefix(MemBuffer buf, Settings settings, int len, DataTypeDisplayOptions options) {
        return this.getDefaultLabelPrefix();
    }

    @Override
    public String getDefaultOffcutLabelPrefix(MemBuffer buf, Settings settings, int len, DataTypeDisplayOptions options, int offcutLength) {
        return this.getDefaultLabelPrefix(buf, settings, len, options);
    }
}

