/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.block;

import ghidra.program.model.address.Address;
import ghidra.program.model.block.CodeBlock;
import ghidra.program.model.block.CodeBlockIterator;
import ghidra.program.model.block.CodeBlockModel;
import ghidra.program.model.block.CodeBlockReference;
import ghidra.program.model.block.CodeBlockReferenceImpl;
import ghidra.program.model.block.CodeBlockReferenceIterator;
import ghidra.program.model.symbol.FlowType;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.LinkedList;
import java.util.List;

public class SubroutineSourceReferenceIterator
implements CodeBlockReferenceIterator {
    private LinkedList<CodeBlockReference> blockRefQueue = new LinkedList();
    private TaskMonitor monitor;

    public SubroutineSourceReferenceIterator(CodeBlock block, TaskMonitor monitor) throws CancelledException {
        this.monitor = monitor;
        SubroutineSourceReferenceIterator.getSources(block, this.blockRefQueue, monitor);
    }

    @Override
    public CodeBlockReference next() throws CancelledException {
        this.monitor.checkCanceled();
        return this.blockRefQueue.isEmpty() ? null : this.blockRefQueue.removeFirst();
    }

    @Override
    public boolean hasNext() throws CancelledException {
        this.monitor.checkCanceled();
        return !this.blockRefQueue.isEmpty();
    }

    public static int getNumSources(CodeBlock block, TaskMonitor monitor) throws CancelledException {
        return SubroutineSourceReferenceIterator.getSources(block, null, monitor);
    }

    private static int getSources(CodeBlock block, List<CodeBlockReference> blockRefQueue, TaskMonitor monitor) throws CancelledException {
        if (block == null || block.getMinAddress() == null) {
            return 0;
        }
        int count = 0;
        CodeBlockModel model = block.getModel();
        CodeBlockIterator bblockIter = model.getBasicBlockModel().getCodeBlocksContaining(block, monitor);
        while (bblockIter.hasNext()) {
            CodeBlock bblock = bblockIter.next();
            CodeBlockReferenceIterator bbSrcIter = bblock.getSources(monitor);
            while (bbSrcIter.hasNext()) {
                Address srcAddr;
                CodeBlockReference bbSrcRef = bbSrcIter.next();
                FlowType refFlowType = bbSrcRef.getFlowType();
                if (refFlowType.isCall()) {
                    count += SubroutineSourceReferenceIterator.queueSrcReferences(blockRefQueue, block, bbSrcRef.getReference(), bbSrcRef.getReferent(), refFlowType, monitor);
                    continue;
                }
                if (!refFlowType.isJump() && !refFlowType.isFallthrough() || block.contains(srcAddr = bbSrcRef.getReferent()) || model.getFirstCodeBlockContaining(srcAddr, monitor) == null) continue;
                count += SubroutineSourceReferenceIterator.queueSrcReferences(blockRefQueue, block, bbSrcRef.getReference(), srcAddr, refFlowType, monitor);
            }
        }
        return count;
    }

    private static int queueSrcReferences(List<CodeBlockReference> blockRefQueue, CodeBlock destBlock, Address destAddr, Address srcAddr, FlowType flowType, TaskMonitor monitor) throws CancelledException {
        CodeBlockModel model = destBlock.getModel();
        if (model.allowsBlockOverlap()) {
            CodeBlock[] srcBlocks = model.getCodeBlocksContaining(srcAddr, monitor);
            int cnt = srcBlocks.length;
            if (blockRefQueue != null) {
                for (int i = 0; i < cnt; ++i) {
                    CodeBlockReferenceImpl blockRef = new CodeBlockReferenceImpl(srcBlocks[i], destBlock, flowType, destAddr, srcAddr);
                    blockRefQueue.add(blockRef);
                }
            }
            if (cnt != 0) {
                return cnt;
            }
        }
        if (blockRefQueue != null) {
            CodeBlockReferenceImpl blockRef = new CodeBlockReferenceImpl(null, destBlock, flowType, destAddr, srcAddr);
            blockRefQueue.add(blockRef);
        }
        return 1;
    }
}

