/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.address;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFormatException;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressSpace;
import ghidra.util.NumericUtilities;
import java.math.BigInteger;

public class GenericAddress
implements Address {
    private static final int MAXIMUM_DIGITS = 16;
    private static final int MINIMUM_DIGITS = 8;
    protected static final String zeros = "0000000000000000";
    protected AddressSpace addrSpace;
    protected long offset;

    GenericAddress(long offset, AddressSpace addrSpace) {
        this.addrSpace = addrSpace;
        this.offset = offset;
    }

    GenericAddress(AddressSpace addrSpace, long offset) {
        this.offset = addrSpace.makeValidOffset(offset);
        this.addrSpace = addrSpace;
    }

    @Override
    public Address getAddress(String addrString) throws AddressFormatException {
        return this.addrSpace.getAddress(addrString);
    }

    @Override
    public Address getNewAddress(long byteOffset) {
        return this.addrSpace.getAddress(byteOffset);
    }

    @Override
    public Address getNewAddress(long addrOffset, boolean isAddressableWordOffset) throws AddressOutOfBoundsException {
        return this.addrSpace.getAddress(addrOffset, isAddressableWordOffset);
    }

    @Override
    public Address getNewTruncatedAddress(long addrOffset, boolean isAddressableWordOffset) throws AddressOutOfBoundsException {
        return this.addrSpace.getTruncatedAddress(addrOffset, isAddressableWordOffset);
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    @Override
    public long getAddressableWordOffset() {
        return this.addrSpace.getAddressableWordOffset(this.offset);
    }

    @Override
    public long getUnsignedOffset() {
        if (this.offset >= 0L || !this.addrSpace.hasSignedOffset()) {
            return this.offset;
        }
        long spaceSize = 0L;
        int size = this.addrSpace.getSize();
        if (size != 64) {
            spaceSize = (long)this.addrSpace.getAddressableUnitSize() << size;
        }
        return spaceSize + this.offset;
    }

    @Override
    public AddressSpace getAddressSpace() {
        return this.addrSpace;
    }

    @Override
    public int getSize() {
        return this.addrSpace.getSize();
    }

    @Override
    public long subtract(Address addr) {
        return this.addrSpace.subtract((Address)this, addr);
    }

    @Override
    public Address subtractWrap(long displacement) {
        if (displacement == 0L) {
            return this;
        }
        return this.addrSpace.subtractWrap(this, displacement);
    }

    @Override
    public Address subtractWrapSpace(long displacement) {
        if (displacement == 0L) {
            return this;
        }
        return this.addrSpace.subtractWrapSpace(this, displacement);
    }

    @Override
    public Address subtractNoWrap(long displacement) throws AddressOverflowException {
        if (displacement == 0L) {
            return this;
        }
        return this.addrSpace.subtractNoWrap(this, displacement);
    }

    @Override
    public Address subtract(long displacement) {
        if (displacement == 0L) {
            return this;
        }
        return this.addrSpace.subtract((Address)this, displacement);
    }

    @Override
    public Address addWrap(long displacement) {
        if (displacement == 0L) {
            return this;
        }
        return this.addrSpace.addWrap(this, displacement);
    }

    @Override
    public Address addWrapSpace(long displacement) {
        if (displacement == 0L) {
            return this;
        }
        return this.addrSpace.addWrapSpace(this, displacement);
    }

    @Override
    public Address addNoWrap(long displacement) throws AddressOverflowException {
        if (displacement == 0L) {
            return this;
        }
        return this.addrSpace.addNoWrap((Address)this, displacement);
    }

    @Override
    public Address addNoWrap(BigInteger displacement) throws AddressOverflowException {
        if (displacement.equals(BigInteger.ZERO)) {
            return this;
        }
        return this.addrSpace.addNoWrap(this, displacement);
    }

    @Override
    public Address add(long displacement) {
        if (displacement == 0L) {
            return this;
        }
        return this.addrSpace.add(this, displacement);
    }

    @Override
    public boolean isSuccessor(Address addr) {
        return this.addrSpace.isSuccessor(this, addr);
    }

    @Override
    public int compareTo(Address a) {
        int comp = this.addrSpace.compareTo(a.getAddressSpace());
        if (comp == 0) {
            long otherOffset = a.getOffset();
            if (!this.addrSpace.hasSignedOffset() && this.addrSpace.getMaxAddress().getOffset() < 0L && (this.offset < 0L && otherOffset >= 0L || this.offset >= 0L && otherOffset < 0L)) {
                return this.offset >= 0L ? -1 : 1;
            }
            long diff = this.offset - otherOffset;
            if (diff > 0L) {
                return 1;
            }
            if (diff < 0L) {
                return -1;
            }
        }
        return comp;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GenericAddress)) {
            return false;
        }
        GenericAddress addr = (GenericAddress)o;
        return this.addrSpace.equals(addr.getAddressSpace()) && this.offset == addr.offset;
    }

    @Override
    public int hashCode() {
        int hash1 = this.addrSpace.hashCode();
        int hash3 = (int)(this.offset >> 32) ^ (int)this.offset;
        return hash1 << 16 ^ hash3;
    }

    @Override
    public String toString() {
        return this.toString(this.addrSpace.showSpaceName(), 8);
    }

    @Override
    public String toString(String prefix) {
        boolean showSpace = prefix.length() == 0 && this.addrSpace.showSpaceName();
        return prefix + this.toString(showSpace, 8);
    }

    @Override
    public String toString(boolean showAddressSpace) {
        return this.toString(showAddressSpace, 8);
    }

    @Override
    public String toString(boolean showAddressSpace, boolean pad) {
        return this.toString(showAddressSpace, pad ? 16 : 8);
    }

    @Override
    public String toString(boolean showAddressSpace, int minNumDigits) {
        boolean stackFormat = false;
        StringBuffer buf = new StringBuffer();
        if (this.addrSpace.isStackSpace()) {
            stackFormat = true;
            buf.append("Stack[");
            minNumDigits = 1;
        } else if (showAddressSpace) {
            buf.append(this.addrSpace.toString());
        }
        int unitSize = this.addrSpace.isStackSpace() ? 1 : this.addrSpace.getAddressableUnitSize();
        int maxDigitsSizeForSpace = (this.addrSpace.getSize() - 1) / 4 + 1;
        int padSize = Math.min(minNumDigits, maxDigitsSizeForSpace);
        long displayOffset = this.offset;
        if (stackFormat) {
            if (displayOffset < 0L) {
                buf.append("-");
                displayOffset = -displayOffset;
            }
            buf.append("0x");
        }
        long mod = 0L;
        if (unitSize > 1) {
            mod = displayOffset % (long)unitSize;
            displayOffset = this.addrSpace.getAddressableWordOffset(displayOffset);
        }
        String addressString = Long.toHexString(displayOffset);
        int numHexDigits = addressString.length();
        int numZerosToPad = Math.max(padSize - numHexDigits, 0);
        for (int i = 0; i < numZerosToPad; ++i) {
            buf.append('0');
        }
        buf.append(addressString);
        if (mod != 0L) {
            buf.append('.');
            buf.append(mod);
        }
        if (stackFormat) {
            buf.append("]");
        }
        return buf.toString();
    }

    @Override
    public boolean hasSameAddressSpace(Address addr) {
        return this.addrSpace.equals(addr.getAddressSpace());
    }

    @Override
    public Address next() {
        if (this.addrSpace.getMaxAddress().getOffset() == this.offset) {
            return null;
        }
        return this.addrSpace.addWrap(this, 1L);
    }

    @Override
    public Address previous() {
        if (this.addrSpace.getMinAddress().getOffset() == this.offset) {
            return null;
        }
        return this.addrSpace.subtractWrap(this, 1L);
    }

    @Override
    public Address getPhysicalAddress() {
        AddressSpace physical = this.addrSpace.getPhysicalSpace();
        if (physical == this.addrSpace) {
            return this;
        }
        if (physical != null) {
            return new GenericAddress(physical, this.offset);
        }
        return null;
    }

    @Override
    public int getPointerSize() {
        return this.addrSpace.getPointerSize();
    }

    @Override
    public boolean isMemoryAddress() {
        return this.addrSpace.isMemorySpace();
    }

    @Override
    public boolean isLoadedMemoryAddress() {
        return this.addrSpace.isLoadedMemorySpace();
    }

    @Override
    public boolean isNonLoadedMemoryAddress() {
        return this.addrSpace.isNonLoadedMemorySpace();
    }

    @Override
    public boolean isHashAddress() {
        return this.addrSpace.isHashSpace();
    }

    @Override
    public boolean isStackAddress() {
        return this.addrSpace.isStackSpace();
    }

    @Override
    public boolean isUniqueAddress() {
        return this.addrSpace.isUniqueSpace();
    }

    @Override
    public boolean isConstantAddress() {
        return this.addrSpace.isConstantSpace();
    }

    @Override
    public boolean isVariableAddress() {
        return this.addrSpace.isVariableSpace();
    }

    @Override
    public boolean isRegisterAddress() {
        return this.addrSpace.isRegisterSpace();
    }

    @Override
    public boolean isExternalAddress() {
        return this.addrSpace.isExternalSpace();
    }

    @Override
    public BigInteger getOffsetAsBigInteger() {
        return NumericUtilities.unsignedLongToBigInteger((long)this.offset);
    }
}

