/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.slghsymbol;

import generic.stl.VectorSTL;
import ghidra.pcodeCPort.context.FixedHandle;
import ghidra.pcodeCPort.context.ParserWalker;
import ghidra.pcodeCPort.sleighbase.SleighBase;
import ghidra.pcodeCPort.slghpatexpress.PatternExpression;
import ghidra.pcodeCPort.slghpatexpress.PatternValue;
import ghidra.pcodeCPort.slghsymbol.Constructor;
import ghidra.pcodeCPort.slghsymbol.ValueSymbol;
import ghidra.pcodeCPort.slghsymbol.symbol_type;
import ghidra.pcodeCPort.translate.BadDataError;
import ghidra.pcodeCPort.utils.XmlUtils;
import ghidra.sleigh.grammar.Location;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;

public class ValueMapSymbol
extends ValueSymbol {
    private VectorSTL<Long> valuetable = new VectorSTL();
    private boolean tableisfilled;

    public ValueMapSymbol(Location location) {
        super(location);
    }

    public ValueMapSymbol(Location location, String nm, PatternValue pv, VectorSTL<Long> vt) {
        super(location, nm, pv);
        this.valuetable = new VectorSTL(vt);
        this.checkTableFill();
    }

    @Override
    public symbol_type getType() {
        return symbol_type.valuemap_symbol;
    }

    private void checkTableFill() {
        long min = this.patval.minValue();
        long max = this.patval.maxValue();
        this.tableisfilled = min >= 0L && max < (long)this.valuetable.size();
        for (int i = 0; i < this.valuetable.size(); ++i) {
            if ((Long)this.valuetable.get(i) != 195935983L) continue;
            this.tableisfilled = false;
        }
    }

    @Override
    public Constructor resolve(ParserWalker pos) {
        int ind;
        if (!(this.tableisfilled || (ind = (int)this.patval.getValue(pos)) < this.valuetable.size() && ind >= 0 && (Long)this.valuetable.get(ind) != 195935983L)) {
            throw new BadDataError("No corresponding entry in nametable <" + this.getName() + ">, index=" + ind);
        }
        return null;
    }

    @Override
    public void getFixedHandle(FixedHandle hand, ParserWalker pos) {
        int ind = (int)this.patval.getValue(pos);
        hand.space = pos.getConstSpace();
        hand.offset_space = null;
        hand.offset_offset = (Long)this.valuetable.get(ind);
        hand.size = 0;
    }

    @Override
    public void print(PrintStream s, ParserWalker pos) {
        int ind = (int)this.patval.getValue(pos);
        Long val = (Long)this.valuetable.get(ind);
        if (val >= 0L) {
            s.append("0x").append(Long.toHexString(val));
        } else {
            s.append("-0x").append(Long.toHexString(-val.longValue()));
        }
    }

    @Override
    public void saveXml(PrintStream s) {
        s.append("<valuemap_sym");
        this.saveSleighSymbolXmlHeader(s);
        s.append(">\n");
        this.patval.saveXml(s);
        for (int i = 0; i < this.valuetable.size(); ++i) {
            s.append("<valuetab val=\"").append(Long.toString((Long)this.valuetable.get(i))).append("\"/>\n");
        }
        s.append("</valuemap_sym>\n");
    }

    @Override
    public void saveXmlHeader(PrintStream s) {
        s.append("<valuemap_sym_head");
        this.saveSleighSymbolXmlHeader(s);
        s.append("/>\n");
    }

    @Override
    public void restoreXml(Element el, SleighBase trans) {
        List list = el.getChildren();
        Iterator iter = list.iterator();
        Element element = (Element)iter.next();
        this.patval = (PatternValue)PatternExpression.restoreExpression(element, trans);
        this.patval.layClaim();
        while (iter.hasNext()) {
            Element child = (Element)iter.next();
            long value = XmlUtils.decodeUnknownLong(child.getAttributeValue("val"));
            this.valuetable.push_back((Object)value);
        }
        this.checkTableFill();
    }
}

