/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh.sem;

import ghidra.app.plugin.assembler.sleigh.sem.AssemblyPatternBlock;
import ghidra.app.plugin.assembler.sleigh.util.DbgTimer;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.DisassemblerContext;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.ContextChangeException;
import ghidra.program.model.listing.DefaultProgramContext;
import java.math.BigInteger;

public class AssemblyDefaultContext
implements DisassemblerContext,
DefaultProgramContext {
    protected final SleighLanguage lang;
    protected final Address at;
    protected AssemblyPatternBlock curctx;
    protected AssemblyPatternBlock defctx;
    protected static final DbgTimer dbg = DbgTimer.INACTIVE;

    public AssemblyDefaultContext(SleighLanguage lang) {
        this(lang, null);
    }

    protected AssemblyDefaultContext(SleighLanguage lang, Address at) {
        this.lang = lang;
        this.at = at;
        Register ctxreg = lang.getContextBaseRegister();
        if (null == ctxreg) {
            this.defctx = AssemblyPatternBlock.nop();
            this.curctx = AssemblyPatternBlock.nop();
        } else {
            int size = ctxreg.getMinimumByteSize();
            this.defctx = AssemblyPatternBlock.fromLength(size);
            this.curctx = AssemblyPatternBlock.fromLength(size);
        }
        lang.applyContextSettings(this);
    }

    public void setContextRegister(byte[] val) {
        this.curctx = AssemblyPatternBlock.fromBytes(0, val);
    }

    public AssemblyPatternBlock getDefault() {
        return this.defctx;
    }

    public AssemblyPatternBlock getDefaultAt(Address addr) {
        return new AssemblyDefaultContext(this.lang, addr).getDefault();
    }

    @Override
    public void setValue(Register register, BigInteger value) throws ContextChangeException {
        dbg.println("Set " + register + " to " + value);
    }

    @Override
    public void setRegisterValue(RegisterValue value) throws ContextChangeException {
        dbg.println("Set " + value);
    }

    @Override
    public void clearRegister(Register register) throws ContextChangeException {
        dbg.println("Clear " + register);
    }

    @Override
    public Register getBaseContextRegister() {
        return this.lang.getContextBaseRegister();
    }

    @Override
    public Register[] getRegisters() {
        return this.lang.getRegisters();
    }

    @Override
    public Register getRegister(String name) {
        return this.lang.getRegister(name);
    }

    @Override
    public BigInteger getValue(Register register, boolean signed) {
        if (signed) {
            throw new UnsupportedOperationException();
        }
        if (!register.isProcessorContext()) {
            return null;
        }
        BigInteger res = this.curctx.toBigInteger(register.getMinimumByteSize());
        if (register.isBaseRegister()) {
            return res;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public RegisterValue getRegisterValue(Register register) {
        return new RegisterValue(register, this.getValue(register, false));
    }

    @Override
    public boolean hasValue(Register register) {
        return register.isProcessorContext();
    }

    @Override
    public void setFutureRegisterValue(Address address, RegisterValue value) {
        dbg.println("Set " + value + " at " + address);
    }

    @Override
    public void setFutureRegisterValue(Address fromAddr, Address toAddr, RegisterValue value) {
        dbg.println("Set " + value + " for [" + fromAddr + ":" + toAddr + "]");
    }

    @Override
    public void setDefaultValue(RegisterValue registerValue, Address start, Address end) {
        if (!registerValue.getRegister().isProcessorContext()) {
            return;
        }
        if (this.at != null && (start.compareTo(this.at) > 0 || this.at.compareTo(end) > 0)) {
            return;
        }
        this.defctx = this.defctx.combine(AssemblyPatternBlock.fromRegisterValue(registerValue));
        dbg.println("Combining " + registerValue);
        dbg.println("  " + this.defctx);
    }

    @Override
    public RegisterValue getDefaultValue(Register register, Address address) {
        throw new UnsupportedOperationException();
    }
}

