/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh.expr;

import ghidra.app.plugin.assembler.sleigh.expr.AbstractExpressionSolver;
import ghidra.app.plugin.assembler.sleigh.expr.ConstantValueSolver;
import ghidra.app.plugin.assembler.sleigh.expr.MaskedLong;
import ghidra.app.plugin.assembler.sleigh.expr.NeedsBackfillException;
import ghidra.app.plugin.assembler.sleigh.expr.SolverHint;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolution;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedConstructor;
import ghidra.app.plugin.processors.sleigh.expression.UnaryExpression;
import java.util.Map;
import java.util.Set;

public abstract class AbstractUnaryExpressionSolver<T extends UnaryExpression>
extends AbstractExpressionSolver<T> {
    public AbstractUnaryExpressionSolver(Class<T> tcls) {
        super(tcls);
    }

    @Override
    public AssemblyResolution solve(T exp, MaskedLong goal, Map<String, Long> vals, Map<Integer, Object> res, AssemblyResolvedConstructor cur, Set<SolverHint> hints, String description) throws NeedsBackfillException {
        MaskedLong uval = this.solver.getValue(((UnaryExpression)exp).getUnary(), vals, res, cur);
        try {
            MaskedLong cval;
            if (uval != null && uval.isFullyDefined() && (cval = this.compute(uval)) != null) {
                return ConstantValueSolver.checkConstAgrees(cval, goal, description);
            }
            return this.solver.solve(((UnaryExpression)exp).getUnary(), this.computeInverse(goal), vals, res, cur, hints, description);
        }
        catch (AssertionError e) {
            this.dbg.println("While solving: " + exp + " (" + description + ")");
            throw e;
        }
    }

    @Override
    public MaskedLong getValue(T exp, Map<String, Long> vals, Map<Integer, Object> res, AssemblyResolvedConstructor cur) throws NeedsBackfillException {
        MaskedLong val = this.solver.getValue(((UnaryExpression)exp).getUnary(), vals, res, cur);
        if (val != null) {
            return this.compute(val);
        }
        return null;
    }

    public MaskedLong computeInverse(MaskedLong goal) {
        return this.compute(goal);
    }

    public abstract MaskedLong compute(MaskedLong var1);

    @Override
    public int getInstructionLength(T exp, Map<Integer, Object> res) {
        return this.solver.getInstructionLength(((UnaryExpression)exp).getUnary(), res);
    }

    @Override
    public MaskedLong valueForResolution(T exp, AssemblyResolvedConstructor rc) {
        MaskedLong val = this.solver.valueForResolution(((UnaryExpression)exp).getUnary(), rc);
        return this.compute(val);
    }
}

