/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table.constrainteditor;

import docking.widgets.label.GDHtmlLabel;
import docking.widgets.table.constraint.ColumnConstraint;
import docking.widgets.table.constraint.RangeColumnConstraint;
import docking.widgets.table.constrainteditor.AbstractColumnConstraintEditor;
import docking.widgets.table.constrainteditor.UnsignedLongConstraintEditor;
import docking.widgets.textfield.IntegerTextField;
import ghidra.util.layout.VerticalLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.math.BigInteger;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class UnsignedLongRangeConstraintEditor
extends AbstractColumnConstraintEditor<BigInteger> {
    private static BigInteger MAX_VALUE = UnsignedLongConstraintEditor.MAX_VALUE;
    private IntegerTextField lowerField;
    private IntegerTextField upperField;
    private JLabel infoLabel;
    private String errorMessage;

    public UnsignedLongRangeConstraintEditor(ColumnConstraint<BigInteger> constraint) {
        super(constraint);
    }

    @Override
    protected Component buildInlineEditorComponent() {
        BigInteger minValue = this.getConstraint().getMinValue();
        BigInteger maxValue = this.getConstraint().getMaxValue();
        JPanel panel = new JPanel((LayoutManager)new VerticalLayout(2));
        this.lowerField = new IntegerTextField(16, minValue);
        this.upperField = new IntegerTextField(16, maxValue);
        this.configureField(this.lowerField);
        this.configureField(this.upperField);
        JPanel rangeControlPanel = new JPanel(new GridLayout(1, 2));
        rangeControlPanel.add(this.lowerField.getComponent());
        rangeControlPanel.add(this.upperField.getComponent());
        panel.add(rangeControlPanel);
        this.infoLabel = new GDHtmlLabel();
        this.infoLabel.setForeground(Color.GRAY);
        this.infoLabel.setHorizontalAlignment(0);
        panel.add(this.infoLabel);
        return panel;
    }

    private void configureField(IntegerTextField field) {
        field.setHexMode();
        field.setAllowNegativeValues(false);
        field.setMaxValue(MAX_VALUE);
        field.addChangeListener(e -> this.valueChanged());
    }

    @Override
    protected void updateInfoMessage(boolean isValid) {
        String status = UnsignedLongRangeConstraintEditor.formatStatus(isValid ? "&nbsp;" : this.errorMessage, true);
        this.infoLabel.setText(status);
    }

    @Override
    public void reset() {
        BigInteger newMinValue = BigInteger.ZERO;
        BigInteger newMaxValue = MAX_VALUE;
        this.setValue(this.getConstraint().copy(newMinValue, newMaxValue));
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    protected ColumnConstraint<BigInteger> getValueFromComponent() {
        BigInteger lowerValue = this.lowerField.getValue();
        BigInteger upperValue = this.upperField.getValue();
        return this.getConstraint().copy(lowerValue, upperValue);
    }

    @Override
    protected boolean checkEditorValueValidity() {
        BigInteger upperValue;
        boolean isValidLower = UnsignedLongRangeConstraintEditor.hasValidValue(this.lowerField);
        boolean isValidUpper = UnsignedLongRangeConstraintEditor.hasValidValue(this.upperField);
        this.errorMessage = "";
        if (!isValidLower || !isValidUpper) {
            this.errorMessage = "Please enter a value for both the lower and upper bounds";
            return false;
        }
        BigInteger lowerValue = this.lowerField.getValue();
        if (lowerValue.compareTo(upperValue = this.upperField.getValue()) > 0) {
            this.errorMessage = "Upper bound must be greater or equal to lower bound!";
            return false;
        }
        return true;
    }

    private static boolean hasValidValue(IntegerTextField field) {
        return field.getValue() != null;
    }

    @Override
    protected void updateEditorComponent() {
        if (this.hasEditorComponents()) {
            BigInteger minValue = this.getConstraint().getMinValue();
            BigInteger maxValue = this.getConstraint().getMaxValue();
            this.lowerField.setValue(minValue);
            this.upperField.setValue(maxValue);
        }
        this.valueChanged();
    }

    private RangeColumnConstraint<BigInteger> getConstraint() {
        return (RangeColumnConstraint)this.currentConstraint;
    }

    IntegerTextField getLowerField() {
        return this.lowerField;
    }

    IntegerTextField getUpperField() {
        return this.upperField;
    }
}

