/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table;

import docking.widgets.table.RowObjectFilterModel;
import docking.widgets.table.RowObjectTableModel;
import docking.widgets.table.SelectionManager;
import docking.widgets.table.SelectionManagerListener;
import docking.widgets.table.SelectionStorage;
import docking.widgets.table.TableFilter;
import ghidra.util.Msg;
import ghidra.util.datastruct.WeakDataStructureFactory;
import ghidra.util.datastruct.WeakSet;
import java.awt.Rectangle;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.apache.commons.collections4.map.LazyMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import utilities.util.ArrayUtilities;
import utilities.util.reflection.ReflectionUtilities;

public class RowObjectSelectionManager<T>
extends DefaultListSelectionModel
implements SelectionManager {
    private static final int ARTIFICIAL_ROW_COUNT_THRESHOLD = 10000;
    private Logger log = LogManager.getLogger(RowObjectSelectionManager.class);
    private DateFormat DATE_FORMAT = new SimpleDateFormat("hh:mm:ss:SSSS");
    private WeakSet<SelectionManagerListener> listeners = WeakDataStructureFactory.createSingleThreadAccessWeakSet();
    private JTable table;
    private FilterModelAdapter modelAdapter;
    private long lastSelectionUpdateTimeStamp;
    private boolean ignoreSelectionChange;
    private boolean restoringSelection;

    public RowObjectSelectionManager(JTable table, RowObjectTableModel<T> model) {
        this.table = table;
        this.modelAdapter = model instanceof RowObjectFilterModel ? new FilterModelPassThrough((RowObjectFilterModel)model) : new FilterModelAdapter(model);
        this.modelAdapter.addTableModelListener(this);
        this.installListSelectionListener();
    }

    @Override
    public void addSelectionManagerListener(SelectionManagerListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removeSelectionManagerListener(SelectionManagerListener listener) {
        this.listeners.remove((Object)listener);
    }

    private void installListSelectionListener() {
        ListSelectionModel oldSelectionModel = this.table.getSelectionModel();
        if (!(oldSelectionModel instanceof DefaultListSelectionModel)) {
            Msg.debug((Object)this, (Object)"Don't know how to extract listeners from a ListSelectionModel that is not a DefaultListSelectionModel.  Any listeners installed on this model before installing this TableFilterPanel will be lost!");
        } else {
            ListSelectionListener[] installedListeners;
            DefaultListSelectionModel defaultListSelectionModel = (DefaultListSelectionModel)oldSelectionModel;
            for (ListSelectionListener listener : installedListeners = defaultListSelectionModel.getListSelectionListeners()) {
                this.addListSelectionListener(listener);
            }
        }
        this.removeListSelectionListener(this.table);
        this.table.setSelectionModel(this);
    }

    @Override
    public void dispose() {
        this.trace("dispose()");
        this.modelAdapter.removeTableModelListener(this);
        this.modelAdapter.clearLastSelectedObjects();
    }

    @Override
    public void clearSavedSelection() {
        this.trace("clearing saved selection");
        this.modelAdapter.clearLastSelectedObjects();
        this.lastSelectionUpdateTimeStamp = -1L;
    }

    @Override
    public void clearSelection() {
        this.ignoreSelectionChange = true;
        super.clearSelection();
    }

    @Override
    protected void fireValueChanged(int firstIndex, int lastIndex, boolean isAdjusting) {
        boolean isTransientChange;
        if (!this.shouldTrackSelection(isAdjusting, firstIndex)) {
            this.superFireValueChanged(firstIndex, lastIndex, isAdjusting, false);
            return;
        }
        boolean bl = isTransientChange = isAdjusting && !this.table.isEditing();
        if (isTransientChange) {
            this.superFireValueChanged(firstIndex, lastIndex, isAdjusting, false);
            return;
        }
        int[] selectedRows = this.table.getSelectedRows();
        this.saveSelectionState(selectedRows);
        this.superFireValueChanged(firstIndex, lastIndex, isAdjusting, true);
    }

    private void superFireValueChanged(int firstIndex, int lastIndex, boolean isAdjusting, boolean isTrackingSelectionChange) {
        this.trace("superFireValueChanged(" + firstIndex + "," + lastIndex + ") ");
        if (!isAdjusting && isTrackingSelectionChange) {
            this.trace("\tresetting last selection timestamp");
            this.lastSelectionUpdateTimeStamp = -1L;
        }
        super.fireValueChanged(firstIndex, lastIndex, isAdjusting);
    }

    private boolean shouldTrackSelection(boolean isAdjusting, int firstIndex) {
        if (this.restoringSelection) {
            return false;
        }
        if (!this.ignoreSelectionChange) {
            return true;
        }
        if (!isAdjusting) {
            this.ignoreSelectionChange = false;
            if (this.table.getSelectedRow() != -1) {
                return true;
            }
        }
        return false;
    }

    private void saveSelectionState(int[] selectedRows) {
        this.traceRows("saveSelectionState(): ", selectedRows);
        this.trace("\tfrom", new Throwable());
        this.modelAdapter.clearLastSelectedObjects();
        if (this.modelAdapter.getUnfilteredRowCount() == 0) {
            return;
        }
        this.trace("\tstoring data");
        List<T> lastSelectedObjects = this.translateRowsToValues(selectedRows);
        this.modelAdapter.setLastSelectedObjects(lastSelectedObjects);
        this.trace("\tfinal stored data: " + this.toString(lastSelectedObjects));
    }

    private String toString(List<T> list) {
        if (list.isEmpty()) {
            return "<empty>";
        }
        return list.size() + " items - " + list.get(0);
    }

    protected List<T> translateRowsToValues(int[] viewRows) {
        ArrayList values = new ArrayList();
        for (int viewRow : viewRows) {
            Object rowObject = this.modelAdapter.getRowObject(viewRow);
            values.add(rowObject);
        }
        return values;
    }

    private String rowsToString(int[] rows) {
        if (rows.length == 0) {
            return "<empty>";
        }
        StringBuilder buffy = new StringBuilder("[");
        int length = Math.min(rows.length, 100);
        for (int i = 0; i < length; ++i) {
            int row = rows[i];
            buffy.append(row).append(',');
        }
        if (rows.length > 0) {
            buffy.deleteCharAt(buffy.length() - 1);
        }
        if (length != rows.length) {
            buffy.append("...");
        }
        buffy.append(']');
        return buffy.toString();
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.maybeRepairSelection();
    }

    private void maybeRepairSelection() {
        this.trace("maybeRepairSelection()");
        if (this.modelAdapter.getLastSelectedObjects().isEmpty()) {
            this.trace("\tselection is empty");
            return;
        }
        int rowCount = this.modelAdapter.getRowCount();
        if (rowCount == 0) {
            this.trace("\tno rows in the table to select");
            return;
        }
        this.repairSelection();
    }

    private void repairSelection() {
        this.lastSelectionUpdateTimeStamp = System.currentTimeMillis();
        if (this.selectionHistoryExpired(this.lastSelectionUpdateTimeStamp)) {
            return;
        }
        long currentRequestTimeStamp = this.lastSelectionUpdateTimeStamp;
        SwingUtilities.invokeLater(() -> {
            this.trace("\trepair selection swing later - " + this.getTimestampString(this.lastSelectionUpdateTimeStamp));
            if (this.selectionHistoryExpired(currentRequestTimeStamp)) {
                return;
            }
            int[] updatedViewRows = this.translateSavedObjectSelectionToRowIndexes();
            this.selectRows(updatedViewRows);
        });
    }

    private int[] translateSavedObjectSelectionToRowIndexes() {
        List lastSelectedObjects = this.modelAdapter.getLastSelectedObjects();
        if (lastSelectedObjects.isEmpty()) {
            return new int[0];
        }
        this.trace("\ttranslate this objects back to indices: " + lastSelectedObjects.get(0));
        Map<Object, List<Integer>> objectRowMap = this.mapAllTableRowObjectToIndexes();
        if (objectRowMap.isEmpty()) {
            return new int[0];
        }
        List<Integer> rowsList = this.translateRowObjectsToIndices(lastSelectedObjects, objectRowMap);
        int[] asInts = rowsList.stream().mapToInt(i -> i).toArray();
        return asInts;
    }

    private List<Integer> translateRowObjectsToIndices(List<T> rowObjects, Map<Object, List<Integer>> objectRowMap) {
        ArrayList<Integer> rowsList = new ArrayList<Integer>();
        int rowCount = this.modelAdapter.getRowCount();
        block0: for (int i = 0; i < rowObjects.size(); ++i) {
            T object = rowObjects.get(i);
            List<Integer> integerList = objectRowMap.get(object);
            if (integerList == null) continue;
            Iterator<Integer> iterator = integerList.iterator();
            while (iterator.hasNext()) {
                Integer rowIndex = iterator.next();
                iterator.remove();
                if (rowIndex >= rowCount) continue;
                rowsList.add(rowIndex);
                continue block0;
            }
        }
        return rowsList;
    }

    private Map<Object, List<Integer>> mapAllTableRowObjectToIndexes() {
        int rowCount = this.modelAdapter.getRowCount();
        if (rowCount > 10000) {
            return Collections.emptyMap();
        }
        LazyMap objectRowMap = LazyMap.lazyMap(new HashMap(), () -> new ArrayList());
        for (int i = 0; i < rowCount; ++i) {
            Object object = this.modelAdapter.getRowObject(i);
            List integerList = (List)objectRowMap.get(object);
            integerList.add(i);
            objectRowMap.put(object, integerList);
        }
        return objectRowMap;
    }

    private String getTimestampString(long timestamp) {
        return this.DATE_FORMAT.format(new Date(timestamp));
    }

    private void selectRows(int[] selectedViewRows) {
        if (selectedViewRows.length == 0) {
            return;
        }
        this.restoreSelectedRows(selectedViewRows);
        Rectangle cellRect = this.table.getCellRect(selectedViewRows[0], 0, true);
        if (cellRect != null) {
            this.table.scrollRectToVisible(cellRect);
        }
    }

    private void restoreSelectedRows(int[] rows) {
        this.traceRows("restoreSelectedRows(): ", rows);
        if (ArrayUtilities.isArrayPrimativeEqual((Object)rows, (Object)this.table.getSelectedRows())) {
            this.trace("\tselection hasn't changed--nothing to do");
            return;
        }
        this.trace("\tpreparing to restore selection");
        this.notifyRestoringSelection(true);
        this.restoringSelection = true;
        ListSelectionModel selectionModel = this.table.getSelectionModel();
        selectionModel.setValueIsAdjusting(true);
        selectionModel.clearSelection();
        for (int row : rows) {
            selectionModel.addSelectionInterval(row, row);
        }
        selectionModel.setValueIsAdjusting(false);
        this.restoringSelection = false;
        this.notifyRestoringSelection(false);
        this.trace("\tdone restoring selection");
    }

    private void notifyRestoringSelection(boolean isPreRestore) {
        for (SelectionManagerListener listener : this.listeners) {
            listener.restoringSelection(isPreRestore);
        }
    }

    private void trace(String s) {
        this.trace(s, null);
    }

    private void trace(String s, Throwable t) {
        Throwable filtered = t == null ? null : ReflectionUtilities.filterJavaThrowable((Throwable)t);
        this.log.trace(s, filtered);
    }

    private void traceRows(String message, int[] rows) {
        if (this.log.isTraceEnabled()) {
            this.trace(message + this.rowsToString(rows));
        }
    }

    private boolean selectionHistoryExpired(long currentTimestamp) {
        if (this.lastSelectionUpdateTimeStamp != currentTimestamp) {
            this.trace("\tlast selection no longer valid--newer request has been made.\n\t\tvalidating time: " + this.getTimestampString(currentTimestamp) + " against most recent: " + this.getTimestampString(this.lastSelectionUpdateTimeStamp));
            return true;
        }
        return false;
    }

    private class SelectionStorageHelper
    implements SelectionStorage<T> {
        private List<T> lastSelectedObjects = new ArrayList();

        private SelectionStorageHelper() {
        }

        @Override
        public List<T> getLastSelectedObjects() {
            return this.lastSelectedObjects;
        }

        @Override
        public void setLastSelectedObjects(List<T> lastSelectedObjects) {
            this.lastSelectedObjects = lastSelectedObjects;
        }
    }

    private class FilterModelPassThrough
    extends FilterModelAdapter {
        private final RowObjectFilterModel<T> filterModel;

        FilterModelPassThrough(RowObjectFilterModel<T> model) {
            super(model);
            this.filterModel = model;
        }

        @Override
        public int getUnfilteredRowCount() {
            return this.filterModel.getUnfilteredRowCount();
        }

        @Override
        public int getModelRow(int viewRow) {
            return this.filterModel.getModelRow(viewRow);
        }

        @Override
        public int getViewRow(int modelRow) {
            return this.filterModel.getViewRow(modelRow);
        }

        @Override
        public boolean isFiltered() {
            return this.filterModel.isFiltered();
        }

        @Override
        public void setTableFilter(TableFilter<T> filter) {
            this.filterModel.setTableFilter(filter);
        }

        @Override
        public List<T> getUnfilteredData() {
            return this.filterModel.getUnfilteredData();
        }
    }

    private class FilterModelAdapter
    implements RowObjectFilterModel<T> {
        private SelectionStorage<T> selectionStorage;
        protected RowObjectTableModel<T> model;

        FilterModelAdapter(RowObjectTableModel<T> model) {
            this.model = model;
            this.selectionStorage = model instanceof SelectionStorage ? (SelectionStorage)((Object)model) : new SelectionStorageHelper();
            this.setLastSelectedObjects(new ArrayList());
        }

        @Override
        public String getName() {
            return this.model.getName();
        }

        @Override
        public int getModelRow(int viewRow) {
            return viewRow;
        }

        @Override
        public int getViewRow(int modelRow) {
            return modelRow;
        }

        @Override
        public boolean isFiltered() {
            return false;
        }

        @Override
        public void setTableFilter(TableFilter<T> filter) {
        }

        @Override
        public TableFilter<T> getTableFilter() {
            return null;
        }

        @Override
        public List<T> getUnfilteredData() {
            return this.model.getModelData();
        }

        @Override
        public int getUnfilteredRowCount() {
            return this.model.getRowCount();
        }

        @Override
        public void fireTableDataChanged() {
            this.model.fireTableDataChanged();
        }

        @Override
        public void addTableModelListener(TableModelListener listener) {
            this.model.addTableModelListener(listener);
        }

        @Override
        public void removeTableModelListener(TableModelListener listener) {
            this.model.removeTableModelListener(listener);
        }

        List<T> getLastSelectedObjects() {
            return this.selectionStorage.getLastSelectedObjects();
        }

        void setLastSelectedObjects(List<T> lastSelectedObjects) {
            this.selectionStorage.setLastSelectedObjects(lastSelectedObjects);
        }

        void clearLastSelectedObjects() {
            this.getLastSelectedObjects().clear();
        }

        @Override
        public T getRowObject(int viewRow) {
            return this.model.getRowObject(viewRow);
        }

        @Override
        public int getRowIndex(T t) {
            return this.model.getRowIndex(t);
        }

        @Override
        public int getViewIndex(T t) {
            return this.model.getRowIndex(t);
        }

        @Override
        public int getModelIndex(T t) {
            return this.model.getRowIndex(t);
        }

        @Override
        public List<T> getModelData() {
            return this.model.getModelData();
        }

        @Override
        public int getRowCount() {
            return this.model.getRowCount();
        }

        @Override
        public int getColumnCount() {
            return this.model.getColumnCount();
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.model.getColumnName(columnIndex);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return this.model.getColumnClass(columnIndex);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return this.model.isCellEditable(rowIndex, columnIndex);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.model.getValueAt(rowIndex, columnIndex);
        }

        @Override
        public Object getColumnValueForRow(T t, int columnIndex) {
            return this.model.getColumnValueForRow(t, columnIndex);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            this.model.setValueAt(aValue, rowIndex, columnIndex);
        }
    }
}

