/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.filechooser;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.filechooser.GhidraFileChooserDirectoryModelIf;
import docking.widgets.filechooser.RecentGhidraFile;
import java.io.File;
import java.util.ArrayList;

class FileChooserActionManager {
    private static final String OWNER = "Ghidra File Chooser";
    private GhidraFileChooser chooser;
    private DockingAction renameAction;
    private DockingAction removeRecentAction;

    FileChooserActionManager(GhidraFileChooser chooser) {
        this.chooser = chooser;
        this.createActions();
    }

    void dispose() {
        this.renameAction.dispose();
        this.removeRecentAction.dispose();
    }

    private void createActions() {
        this.renameAction = new DockingAction("Rename", OWNER){

            @Override
            public void actionPerformed(ActionContext context) {
                FileChooserActionManager.this.rename();
            }

            @Override
            public boolean isEnabledForContext(ActionContext context) {
                Object contextObject = context.getContextObject();
                if (!(contextObject instanceof GhidraFileChooserDirectoryModelIf)) {
                    return false;
                }
                File dir = FileChooserActionManager.this.chooser.getCurrentDirectory();
                if (dir == GhidraFileChooser.MY_COMPUTER || dir == GhidraFileChooser.RECENT) {
                    return false;
                }
                GhidraFileChooserDirectoryModelIf model = (GhidraFileChooserDirectoryModelIf)contextObject;
                File file = model.getSelectedFile();
                return file != null;
            }

            @Override
            public boolean isAddToPopup(ActionContext context) {
                Object contextObject = context.getContextObject();
                if (!(contextObject instanceof GhidraFileChooserDirectoryModelIf)) {
                    return false;
                }
                GhidraFileChooserDirectoryModelIf model = (GhidraFileChooserDirectoryModelIf)contextObject;
                File file = model.getSelectedFile();
                return file != null;
            }
        };
        this.renameAction.setPopupMenuData(new MenuData(new String[]{"Rename"}, "A"));
        this.renameAction.markHelpUnnecessary();
        this.chooser.addAction(this.renameAction);
        this.removeRecentAction = new DockingAction("Remove Recent", OWNER){

            @Override
            public void actionPerformed(ActionContext context) {
                FileChooserActionManager.this.removeRecent();
            }

            @Override
            public boolean isEnabledForContext(ActionContext context) {
                Object contextObject = context.getContextObject();
                if (!(contextObject instanceof GhidraFileChooserDirectoryModelIf)) {
                    return false;
                }
                GhidraFileChooserDirectoryModelIf model = (GhidraFileChooserDirectoryModelIf)contextObject;
                File file = model.getSelectedFile();
                return file != null && file instanceof RecentGhidraFile;
            }
        };
        this.removeRecentAction.setPopupMenuData(new MenuData(new String[]{"Remove Recent"}, "B"));
        this.removeRecentAction.markHelpUnnecessary();
        this.chooser.addAction(this.removeRecentAction);
    }

    private void rename() {
        File dir = this.chooser.getCurrentDirectory();
        if (dir == GhidraFileChooser.MY_COMPUTER || dir == GhidraFileChooser.RECENT) {
            this.chooser.setStatusText("Unable to rename inside directory \"" + dir + "\"");
            return;
        }
        GhidraFileChooserDirectoryModelIf model = this.chooser.getDirectoryModel();
        int[] rows = model.getSelectedRows();
        if (rows.length == 1) {
            model.edit();
        }
    }

    private void removeRecent() {
        int[] rows;
        ArrayList<RecentGhidraFile> toRemove = new ArrayList<RecentGhidraFile>();
        GhidraFileChooserDirectoryModelIf model = this.chooser.getDirectoryModel();
        for (int row : rows = model.getSelectedRows()) {
            File file = model.getFile(row);
            if (!(file instanceof RecentGhidraFile)) continue;
            toRemove.add((RecentGhidraFile)file);
        }
        this.chooser.removeRecentFiles(toRemove);
    }

    DockingAction getRenameAction() {
        return this.renameAction;
    }

    DockingAction getRemoveRecentAction() {
        return this.removeRecentAction;
    }
}

