/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.fieldpanel.internal;

import java.awt.Color;

public class PaintContext {
    private Color defaultBackground;
    private Color background;
    private Color foreground;
    private Color selectionColor;
    private Color highlightColor;
    private Color selectedHighlightColor;
    private Color printColor;
    private Color cursorColor;
    private Color focusedCursorColor;
    private Color notFocusedCursorColor;
    private Color invisibleCursorColor;
    private boolean printing = false;
    private boolean textCopying = false;

    public PaintContext() {
        this.defaultBackground = Color.white;
        this.background = Color.white;
        this.foreground = Color.black;
        this.selectionColor = new Color(180, 255, 180);
        this.highlightColor = new Color(255, 255, 150);
        this.selectedHighlightColor = Color.green;
        this.cursorColor = this.focusedCursorColor = Color.RED;
        this.invisibleCursorColor = new Color(255, 0, 0, 1);
        this.notFocusedCursorColor = Color.PINK;
    }

    public PaintContext(PaintContext other) {
        this.defaultBackground = other.defaultBackground;
        this.background = other.background;
        this.foreground = other.foreground;
        this.selectionColor = other.selectionColor;
        this.highlightColor = other.highlightColor;
        this.selectedHighlightColor = other.selectedHighlightColor;
        this.cursorColor = other.cursorColor;
        this.focusedCursorColor = other.focusedCursorColor;
        this.notFocusedCursorColor = other.notFocusedCursorColor;
        this.invisibleCursorColor = other.invisibleCursorColor;
        this.printColor = other.printColor;
    }

    public final Color getDefaultBackground() {
        return this.defaultBackground;
    }

    public final Color getBackground() {
        return this.background;
    }

    public final Color getForeground() {
        return this.foreground;
    }

    public final Color getSelectionColor() {
        return this.selectionColor;
    }

    public final Color getHighlightColor() {
        return this.highlightColor;
    }

    public final Color getSelectedHighlightColor() {
        return this.selectedHighlightColor;
    }

    public final Color getCursorColor() {
        return this.cursorColor;
    }

    public final Color getFocusedCursorColor() {
        return this.focusedCursorColor;
    }

    public void setSelectionColor(Color c) {
        this.selectionColor = c;
        this.adjustSelectedHighlightColor();
    }

    public void setHighlightColor(Color c) {
        this.highlightColor = c;
        this.adjustSelectedHighlightColor();
    }

    public void setDefaultBackgroundColor(Color c) {
        this.defaultBackground = c;
    }

    public final boolean isDefaultBackground() {
        return this.defaultBackground.equals(this.background);
    }

    private void adjustSelectedHighlightColor() {
        int red = (this.selectionColor.getRed() + this.highlightColor.getRed()) / 2;
        int green = (this.selectionColor.getGreen() + this.highlightColor.getGreen()) / 2;
        int blue = (this.selectionColor.getBlue() + this.highlightColor.getBlue()) / 2;
        this.selectedHighlightColor = new Color(red, green, blue);
    }

    public void setBackgroundColor(Color c) {
        this.background = c;
    }

    public void setForegroundColor(Color c) {
        this.foreground = c;
    }

    public void setCursorColor(Color c) {
        this.cursorColor = c;
        this.invisibleCursorColor = new Color(c.getRed(), c.getGreen(), c.getBlue(), 1);
    }

    public boolean cursorHidden() {
        return this.cursorColor == this.invisibleCursorColor;
    }

    public boolean cursorFocused() {
        return this.cursorColor == this.focusedCursorColor;
    }

    public void setCursorFocused(boolean isFocused) {
        this.cursorColor = isFocused ? this.focusedCursorColor : this.notFocusedCursorColor;
    }

    public void setCursorHidden(boolean isHidden) {
        this.cursorColor = isHidden ? this.invisibleCursorColor : this.focusedCursorColor;
    }

    public void setFocusedCursorColor(Color color) {
        this.focusedCursorColor = color;
    }

    public void setNotFocusedCursorColor(Color color) {
        this.notFocusedCursorColor = color;
    }

    public Color getNotFocusedCursorColor() {
        return this.notFocusedCursorColor;
    }

    public void setPrintColor(Color c) {
        this.printColor = c;
    }

    public void setPrinting(boolean b) {
        this.printing = b;
    }

    public void setTextCopying(boolean b) {
        this.textCopying = b;
    }

    public boolean isPrinting() {
        return this.printing;
    }

    public boolean isTextCopying() {
        return this.textCopying;
    }
}

