/*
 * Decompiled with CFR 0.152.
 */
package ghidra.python;

import ghidra.python.PythonPlugin;
import ghidra.python.PythonPluginExecutionThread;
import ghidra.util.Msg;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.concurrent.atomic.AtomicBoolean;

class PythonPluginInputThread
extends Thread {
    private static int generationCount = 0;
    private PythonPlugin plugin;
    private PythonPluginExecutionThread pythonExecutionThread;
    private AtomicBoolean moreInputWanted;
    private AtomicBoolean shouldContinue;

    PythonPluginInputThread(PythonPlugin plugin) {
        super("Python plugin input thread (generation " + ++generationCount + ")");
        this.plugin = plugin;
        this.moreInputWanted = new AtomicBoolean(false);
        this.shouldContinue = new AtomicBoolean(true);
    }

    PythonPluginExecutionThread getPythonPluginExecutionThread() {
        return this.pythonExecutionThread;
    }

    @Override
    public void run() {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.plugin.getConsole().getStdin()));){
            while (this.shouldContinue.get()) {
                if (this.plugin.getConsole().getStdin().available() <= 0) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                String line = reader.readLine();
                this.pythonExecutionThread = new PythonPluginExecutionThread(this.plugin, line, this.moreInputWanted);
                this.pythonExecutionThread.start();
                try {
                    this.pythonExecutionThread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.plugin.getConsole().setPrompt(this.moreInputWanted.get() ? this.plugin.getInterpreter().getSecondaryPrompt() : this.plugin.getInterpreter().getPrimaryPrompt());
            }
        }
        catch (IOException e) {
            Msg.error(PythonPluginInputThread.class, (Object)"Internal error reading commands from interpreter console.  Please reset the interpreter.", (Throwable)e);
        }
    }

    void dispose() {
        this.shouldContinue.set(false);
    }
}

