/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.util;

import docking.widgets.table.GTableCellRenderingData;
import ghidra.feature.vt.gui.util.MungedAssocationAndMarkupItemStatus;
import ghidra.util.table.GhidraTableCellRenderer;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JLabel;
import resources.MultiIcon;
import resources.ResourceManager;
import resources.icons.TranslateIcon;

public class MatchStatusRenderer
extends GhidraTableCellRenderer {
    private static final Icon ACCEPTED_ICON = ResourceManager.loadImage((String)"images/flag.png");
    private static final Icon REJECTED_ICON = ResourceManager.loadImage((String)"images/dialog-cancel.png");
    private static final Icon BLOCKED_ICON = ResourceManager.loadImage((String)"images/kgpg.png");
    private static final Icon WARN_ICON = new TranslateIcon((Icon)ResourceManager.loadImage((String)"images/bullet_error.png"), 10, 8);
    private static final Icon FAILURE_ICON = new TranslateIcon((Icon)ResourceManager.getScaledIcon((Icon)ResourceManager.loadImage((String)"images/edit-delete.png"), (int)8, (int)8), 10, 8);
    private static final Icon FULLY_APPLIED_ICON = new TranslateIcon((Icon)ResourceManager.getScaledIcon((Icon)ResourceManager.loadImage((String)"images/checkmark_green.gif"), (int)8, (int)8), 10, 8);
    private static final Icon FULLY_CONSIDERED_ICON = new TranslateIcon((Icon)ResourceManager.getScaledIcon((Icon)ResourceManager.loadImage((String)"images/checkmark_yellow.gif"), (int)8, (int)8), 10, 8);

    public Component getTableCellRendererComponent(GTableCellRenderingData data) {
        JLabel renderer = (JLabel)super.getTableCellRendererComponent(data);
        Object value = data.getValue();
        renderer.setText("");
        renderer.setHorizontalAlignment(0);
        MungedAssocationAndMarkupItemStatus status = (MungedAssocationAndMarkupItemStatus)((Object)value);
        if (status == null) {
            return renderer;
        }
        Icon icon = null;
        switch (status) {
            case ACCEPTED_FULLY_APPLIED: {
                icon = new MultiIcon(ACCEPTED_ICON, new Icon[]{FULLY_APPLIED_ICON});
                break;
            }
            case ACCEPTED_HAS_ERRORS: {
                icon = new MultiIcon(ACCEPTED_ICON, new Icon[]{FAILURE_ICON});
                break;
            }
            case ACCEPTED_NO_UNEXAMINED: {
                icon = new MultiIcon(ACCEPTED_ICON, new Icon[]{FULLY_CONSIDERED_ICON});
                break;
            }
            case ACCEPTED_SOME_UNEXAMINED: {
                icon = new MultiIcon(ACCEPTED_ICON, new Icon[]{WARN_ICON});
                break;
            }
            case AVAILABLE: {
                break;
            }
            case BLOCKED: {
                icon = BLOCKED_ICON;
                break;
            }
            case REJECTED: {
                icon = REJECTED_ICON;
            }
        }
        renderer.setIcon(icon);
        renderer.setToolTipText(status.getDescription());
        return renderer;
    }
}

