/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.provider.relatedMatches;

import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.TableColumnDescriptor;
import ghidra.docking.settings.Settings;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.api.util.VTRelatedMatch;
import ghidra.feature.vt.api.util.VTRelatedMatchUtil;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.provider.relatedMatches.VTRelatedMatchType;
import ghidra.feature.vt.gui.util.MatchInfo;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.table.AddressBasedTableModel;
import ghidra.util.table.field.AbstractProgramBasedDynamicTableColumn;
import ghidra.util.task.TaskMonitor;
import java.util.Collection;

public class VTRelatedMatchTableModel
extends AddressBasedTableModel<VTRelatedMatch> {
    private static final String TITLE = "VTMatchMakupItem Table Model";
    private final VTController controller;

    public VTRelatedMatchTableModel(VTController controller) {
        super(TITLE, controller.getServiceProvider(), controller.getSourceProgram(), null);
        this.controller = controller;
    }

    protected TableColumnDescriptor<VTRelatedMatch> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        descriptor.addVisibleColumn((DynamicTableColumn)new CorrelationTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new SourceAddressTableColumn(), 1, true);
        descriptor.addVisibleColumn((DynamicTableColumn)new SourceFunctionTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new DestinationAddressTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new DestinationFunctionTableColumn());
        return descriptor;
    }

    public Address getAddress(int row) {
        VTRelatedMatch markupItem = (VTRelatedMatch)this.getRowObject(row);
        return markupItem.getSourceAddress();
    }

    protected void doLoad(Accumulator<VTRelatedMatch> accumulator, TaskMonitor monitor) throws CancelledException {
        VTSession session = this.controller.getSession();
        MatchInfo matchInfo = this.controller.getMatchInfo();
        if (matchInfo == null) {
            return;
        }
        Collection<VTRelatedMatch> relatedMatches = VTRelatedMatchUtil.getRelatedMatches(monitor, session, matchInfo.getMatch());
        monitor.setMessage("Processing markup items");
        monitor.initialize((long)relatedMatches.size());
        for (VTRelatedMatch vtRelatedMatch : relatedMatches) {
            monitor.checkCanceled();
            accumulator.add((Object)vtRelatedMatch);
            monitor.incrementProgress(1L);
        }
    }

    public void reload() {
        this.clearData();
        super.reload();
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    private static class DestinationFunctionTableColumn
    extends AbstractProgramBasedDynamicTableColumn<VTRelatedMatch, String> {
        private DestinationFunctionTableColumn() {
        }

        public String getColumnName() {
            return "Destination Function";
        }

        public String getValue(VTRelatedMatch rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject.getDestinationFunction().getName();
        }

        public int getColumnPreferredWidth() {
            return 75;
        }
    }

    private static class DestinationAddressTableColumn
    extends AbstractProgramBasedDynamicTableColumn<VTRelatedMatch, String> {
        private DestinationAddressTableColumn() {
        }

        public String getColumnName() {
            return "Destination Address";
        }

        public String getValue(VTRelatedMatch rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject.getDestinationAddress().toString(false);
        }

        public int getColumnPreferredWidth() {
            return 75;
        }
    }

    private static class SourceFunctionTableColumn
    extends AbstractProgramBasedDynamicTableColumn<VTRelatedMatch, String> {
        private SourceFunctionTableColumn() {
        }

        public String getColumnName() {
            return "Source Function";
        }

        public String getValue(VTRelatedMatch rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject.getSourceFunction().getName();
        }

        public int getColumnPreferredWidth() {
            return 75;
        }
    }

    private static class SourceAddressTableColumn
    extends AbstractProgramBasedDynamicTableColumn<VTRelatedMatch, String> {
        private SourceAddressTableColumn() {
        }

        public String getColumnName() {
            return "Source Address";
        }

        public String getValue(VTRelatedMatch rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject.getSourceAddress().toString(false);
        }

        public int getColumnPreferredWidth() {
            return 75;
        }
    }

    private static class CorrelationTableColumn
    extends AbstractProgramBasedDynamicTableColumn<VTRelatedMatch, VTRelatedMatchType> {
        private CorrelationTableColumn() {
        }

        public String getColumnName() {
            return "Correlation";
        }

        public VTRelatedMatchType getValue(VTRelatedMatch rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject.getCorrelation();
        }

        public int getColumnPreferredWidth() {
            return 75;
        }
    }
}

