/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.widgets.OptionDialog;
import ghidra.app.plugin.core.codebrowser.CodeViewerActionContext;
import ghidra.feature.vt.api.main.VTMatch;
import ghidra.feature.vt.gui.plugin.SubToolContext;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.plugin.VTPlugin;
import ghidra.feature.vt.gui.task.CreateManualMatchTask;
import ghidra.program.model.listing.Function;
import ghidra.util.Msg;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskListener;

public abstract class AbstractManualMatchFromToolsAction
extends DockingAction {
    private final VTPlugin plugin;
    private SubToolContext subToolContext;

    public AbstractManualMatchFromToolsAction(VTPlugin plugin, String name) {
        super(name, VTPlugin.OWNER);
        this.plugin = plugin;
    }

    public void actionPerformed(ActionContext context) {
        Function destinationFunction;
        Function sourceFunction = this.subToolContext.getSourceFunction();
        if (!this.validateSelectedFunctions(sourceFunction, destinationFunction = this.subToolContext.getDestinationFunction())) {
            return;
        }
        final VTController controller = this.plugin.getController();
        if (!this.validateExistingMatch(controller)) {
            return;
        }
        if (!this.validateCursorPosition()) {
            return;
        }
        final CreateManualMatchTask task = this.getTask(controller, sourceFunction, destinationFunction);
        task.addTaskListener(new TaskListener(){

            public void taskCompleted(Task t) {
                controller.setSelectedMatch(task.getNewMatch());
            }

            public void taskCancelled(Task t) {
            }
        });
        TaskLauncher.launch((Task)task);
    }

    protected abstract CreateManualMatchTask getTask(VTController var1, Function var2, Function var3);

    private boolean validateSelectedFunctions(Function sourceFunction, Function destinationFunction) {
        if (sourceFunction == null || destinationFunction == null) {
            Msg.showInfo(((Object)((Object)this)).getClass(), null, (String)"Cannot Create Match", (Object)"The current location must be inside of a function in both the source and destination programs");
            return false;
        }
        return true;
    }

    private boolean validateExistingMatch(VTController controller) {
        VTMatch match = this.subToolContext.getMatch();
        if (match == null) {
            return true;
        }
        int choice = OptionDialog.showOptionNoCancelDialog(null, (String)"Match Exists", (String)"<html>You have attempted to create a manual when a match already exists.<br>Would you like to select the match in the matches table?", (String)"Yes", (String)"No", (int)3);
        if (choice == 1) {
            controller.setSelectedMatch(match);
        }
        return false;
    }

    private boolean validateCursorPosition() {
        int choice;
        boolean sourceCursorOnScreen = this.subToolContext.isSourceCursorOnScreen();
        boolean destinationCursorOnScreen = this.subToolContext.isDestinationCursorOnScreen();
        if (sourceCursorOnScreen && destinationCursorOnScreen) {
            return true;
        }
        Object message = "";
        if (!sourceCursorOnScreen) {
            message = (String)message + " <b>source tool</b>";
        }
        if (!destinationCursorOnScreen) {
            message = (String)message + " and the <b>destination tool</b>";
        }
        return (choice = OptionDialog.showOptionNoCancelDialog(null, (String)"Cursor Offscreen", (String)("<html>Your cursor is off the screen in the " + (String)message + ".<br>There is a chance the cursor is not in the function you currently see.<br>Would you like to continue creating a match?"), (String)"Yes", (String)"No", (int)3)) == 1;
    }

    public boolean isEnabledForContext(ActionContext context) {
        return context instanceof CodeViewerActionContext;
    }

    public boolean isAddToPopup(ActionContext context) {
        if (!(context instanceof CodeViewerActionContext)) {
            return false;
        }
        this.subToolContext = new SubToolContext(this.plugin);
        Function sourceFunction = this.subToolContext.getSourceFunction();
        Function destinationFunction = this.subToolContext.getDestinationFunction();
        VTMatch match = this.subToolContext.getMatch();
        return sourceFunction != null && destinationFunction != null && match == null;
    }
}

