/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.jparted.lib.fs.hfscommon;

import org.catacombae.io.ReadableRandomAccessStream;
import org.catacombae.util.Util;

public class HFSCommonFileSystemRecognizer {
    private static final short SIGNATURE_MFS = -11561;
    private static final short SIGNATURE_HFS = 16964;
    private static final short SIGNATURE_HFS_PLUS = 18475;
    private static final short SIGNATURE_HFSX = 18520;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static FileSystemType detectFileSystem(ReadableRandomAccessStream bitstream, long offset) {
        try {
            bitstream.seek(offset + 1024L);
            byte[] signatureData = new byte[2];
            bitstream.readFully(signatureData);
            short signature = Util.readShortBE((byte[])signatureData);
            switch (signature) {
                case -11561: {
                    return FileSystemType.MFS;
                }
                case 16964: {
                    try {
                        bitstream.seek(offset + 1024L + 124L);
                        bitstream.readFully(signatureData);
                        short embeddedSignature = Util.readShortBE((byte[])signatureData);
                        if (embeddedSignature == 18475) {
                            return FileSystemType.HFS_WRAPPED_HFS_PLUS;
                        }
                        return FileSystemType.HFS;
                    }
                    catch (Exception e) {
                        return FileSystemType.HFS;
                    }
                }
                case 18475: {
                    return FileSystemType.HFS_PLUS;
                }
                case 18520: {
                    return FileSystemType.HFSX;
                }
            }
            return FileSystemType.UNKNOWN;
        }
        catch (Exception e) {
            System.err.println("Exception while detecting file system:");
            e.printStackTrace();
            return FileSystemType.UNKNOWN;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FileSystemType {
        MFS,
        HFS,
        HFS_PLUS,
        HFS_WRAPPED_HFS_PLUS,
        HFSX,
        UNKNOWN;

    }
}

