/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.csjc.structelements;

import org.catacombae.csjc.structelements.FieldType;
import org.catacombae.csjc.structelements.StringRepresentableField;
import org.catacombae.hfsexplorer.Util;

public class ByteArrayField
extends StringRepresentableField {
    private final byte[] fieldData;
    private final int offset;
    private final int length;

    public ByteArrayField(byte[] fieldData) {
        this(fieldData, 0, fieldData.length);
    }

    public ByteArrayField(byte[] fieldData, int offset, int length) {
        super("Byte[" + fieldData.length + "]", FieldType.BYTEARRAY);
        this.fieldData = fieldData;
        this.offset = offset;
        this.length = length;
    }

    public String getValueAsString() {
        return "0x" + Util.byteArrayToHexString((byte[])this.fieldData, (int)this.offset, (int)this.length);
    }

    public void setStringValue(String value) throws IllegalArgumentException {
        throw new UnsupportedOperationException("Can't set byte string to string value at this point.");
    }

    public String validateStringValue(String s) {
        return "Can't set a byte string to a string value.";
    }
}

