/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.fid.service;

import generic.cache.Factory;
import ghidra.feature.fid.hash.FidHashQuad;
import ghidra.feature.fid.hash.FidHasher;
import ghidra.program.model.listing.Function;
import ghidra.program.model.mem.MemoryAccessException;

class FidHasherFactory
implements Factory<Function, FidHashQuad> {
    private final FidHasher hasher;

    public FidHasherFactory(FidHasher hasher) {
        this.hasher = hasher;
    }

    public FidHashQuad get(Function function) {
        try {
            if (function == null) {
                return null;
            }
            return this.hasher.hash(function);
        }
        catch (MemoryAccessException e) {
            return null;
        }
    }
}

