/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.task;

import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.TaskUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.MonitoredRunnable;
import ghidra.util.task.TaskListener;
import ghidra.util.task.TaskMonitor;
import java.util.HashSet;
import java.util.Set;

public abstract class Task
implements MonitoredRunnable {
    private String title;
    private boolean canCancel;
    private boolean hasProgress;
    private boolean isModal;
    private boolean isInterruptible;
    private boolean isForgettable;
    protected boolean waitForTaskCompleted = false;
    private Set<TaskListener> listeners = new HashSet<TaskListener>();
    protected TaskMonitor taskMonitor = TaskMonitor.DUMMY;

    public Task(String title) {
        this(title, true, false, false, false);
    }

    public Task(String title, boolean canCancel, boolean hasProgress, boolean isModal) {
        this(title, canCancel, hasProgress, isModal, false);
    }

    public Task(String title, boolean canCancel, boolean hasProgress, boolean isModal, boolean waitForTaskCompleted) {
        this.title = title;
        this.canCancel = canCancel;
        this.hasProgress = hasProgress;
        this.isModal = isModal;
        if (waitForTaskCompleted && !isModal) {
            throw new IllegalStateException("waitForTaskCompleted only makes sense if the task is modal");
        }
        this.waitForTaskCompleted = waitForTaskCompleted;
    }

    public final String getTaskTitle() {
        return this.title;
    }

    public int getStatusTextAlignment() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void monitoredRun(TaskMonitor monitor) {
        this.taskMonitor = monitor;
        TaskUtilities.addTrackedTask(this, monitor);
        boolean isCancelled = false;
        try {
            this.run(monitor);
            isCancelled = monitor.isCancelled();
        }
        catch (CancelledException e) {
            Msg.debug((Object)this, (Object)("Task cancelled: " + this.getTaskTitle()));
        }
        catch (Throwable t) {
            Msg.showError((Object)this, null, (String)"Task Error", (Object)(this.getTaskTitle() + " - Uncaught Exception: " + t.toString()), (Throwable)t);
        }
        finally {
            TaskUtilities.removeTrackedTask(this);
            this.taskMonitor = null;
        }
        this.notifyTaskListeners(isCancelled);
    }

    public void cancel() {
        if (this.taskMonitor != null) {
            this.taskMonitor.cancel();
        }
    }

    protected void notifyTaskListeners(boolean wasCancelled) {
        if (this.listeners.isEmpty()) {
            return;
        }
        Runnable r = () -> {
            for (TaskListener listener : this.listeners) {
                if (wasCancelled) {
                    listener.taskCancelled(this);
                    continue;
                }
                listener.taskCompleted(this);
            }
        };
        if (this.waitForTaskCompleted) {
            SystemUtilities.runSwingNow((Runnable)r);
        } else {
            SystemUtilities.runSwingLater((Runnable)r);
        }
    }

    public abstract void run(TaskMonitor var1) throws CancelledException;

    public boolean hasProgress() {
        return this.hasProgress;
    }

    public void setHasProgress(boolean b) {
        this.hasProgress = b;
    }

    public boolean canCancel() {
        return this.canCancel;
    }

    public boolean isModal() {
        return this.isModal;
    }

    public void addTaskListener(TaskListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }
}

