/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.graph;

import ghidra.util.Msg;
import ghidra.util.graph.KeyedObject;
import ghidra.util.graph.KeyedObjectFactory;
import ghidra.util.graph.Vertex;

public final class Edge
implements KeyedObject,
Comparable<Edge> {
    private final long key;
    private static final KeyedObjectFactory kof = KeyedObjectFactory.getInstance();
    private final Vertex from;
    private final Vertex to;

    public Edge(Vertex from, Vertex to) {
        if (from == null || to == null) {
            Msg.error((Object)this, (Object)"Bad edge");
        }
        this.key = Edge.getNextKey();
        this.from = from;
        this.to = to;
    }

    private static synchronized long getNextKey() {
        return kof.getNextAvailableKey();
    }

    public Vertex from() {
        return this.from;
    }

    public Vertex to() {
        return this.to;
    }

    @Override
    public long key() {
        return this.key;
    }

    @Override
    public int compareTo(Edge edge) {
        if (this.key() < edge.key()) {
            return -1;
        }
        if (this.key() > edge.key()) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Edge) {
            return this.key == ((Edge)obj).key();
        }
        return false;
    }

    public int hashCode() {
        return (int)this.key;
    }
}

