/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

import java.awt.Color;

public class ColorUtils {
    public static final float HUE_RED = 0.0f;
    public static final float HUE_ORANGE = 0.083333336f;
    public static final float HUE_YELLOW = 0.16666667f;
    public static final float HUE_LIME = 0.25f;
    public static final float HUE_GREEN = 0.33333334f;
    public static final float HUE_PINE = 0.41666666f;
    public static final float HUE_TURQUISE = 0.5f;
    public static final float HUE_SAPPHIRE = 0.5833333f;
    public static final float HUE_BLUE = 0.6666667f;
    public static final float HUE_ROYAL = 0.75f;
    public static final float HUE_PURPLE = 0.8333333f;
    public static final float HUE_PINK = 0.9166667f;

    public static Color deriveBackground(Color src, float hue, float sfact, float bfact) {
        float[] vals = new float[3];
        Color.RGBtoHSB(src.getRed(), src.getGreen(), src.getBlue(), vals);
        vals[0] = hue;
        vals[1] = vals[1] * sfact;
        vals[2] = 0.5f + (vals[2] - 0.5f) * bfact;
        return Color.getHSBColor(vals[0], vals[1], vals[2]);
    }

    public static Color deriveBackground(Color background, float hue) {
        return ColorUtils.deriveBackground(background, hue, 1.0f, 0.9f);
    }

    public static Color deriveForeground(Color bg, float hue, float brt) {
        float[] vals = new float[3];
        Color.RGBtoHSB(bg.getRed(), bg.getGreen(), bg.getBlue(), vals);
        double bx = Math.cos((double)(vals[0] * 2.0f) * Math.PI) * (double)vals[1];
        double by = Math.sin((double)(vals[0] * 2.0f) * Math.PI) * (double)vals[1];
        vals[0] = hue;
        vals[1] = 1.0f - vals[1];
        double fx = Math.cos((double)(vals[0] * 2.0f) * Math.PI) * (double)vals[1];
        double fy = Math.sin((double)(vals[0] * 2.0f) * Math.PI) * (double)vals[1];
        float hsdist = (float)Math.sqrt((bx - fx) * (bx - fx) + (by - fy) * (by - fy));
        float bdiff = 1.0f - hsdist;
        if (Math.abs(vals[2] - brt) < bdiff) {
            if (brt > vals[2]) {
                brt = vals[2] + bdiff;
                if ((double)brt > 1.0) {
                    brt -= 2.0f * bdiff;
                }
            } else {
                brt = vals[2] - bdiff;
                if ((double)brt < 0.0) {
                    brt += 2.0f * bdiff;
                }
            }
            if ((double)brt < 0.0 || (double)brt > 1.0) {
                brt = (double)vals[2] < 0.7 ? 1.0f : 0.0f;
            }
        }
        vals[2] = brt;
        for (int i = 0; i < 3; ++i) {
            vals[i] = Math.min(Math.max(0.0f, vals[i]), 1.0f);
        }
        return Color.getHSBColor(vals[0], vals[1], vals[2]);
    }

    public static Color deriveForeground(Color bg, float hue) {
        return ColorUtils.deriveForeground(bg, hue, 1.0f);
    }

    public static Color contrastForegroundColor(Color color) {
        float[] rgbs = new float[3];
        color.getRGBColorComponents(rgbs);
        int fR = (double)rgbs[0] > 0.5 ? 0 : 1;
        int fG = (double)rgbs[1] > 0.5 ? 0 : 1;
        int fB = (double)rgbs[2] > 0.5 ? 0 : 1;
        double luminance = 0.2126 * (double)(fR * fR) + 0.7152 * (double)(fG * fG) + 0.0722 * (double)(fB * fB);
        Color foreground = Color.WHITE;
        if (luminance < 0.54) {
            foreground = Color.BLACK;
        }
        return foreground;
    }

    public static Color blend(Color c1, Color c2, float ratio) {
        float[] rgb1 = new float[3];
        float[] rgb2 = new float[3];
        c1.getColorComponents(rgb1);
        c2.getColorComponents(rgb2);
        float inverse = 1.0f - ratio;
        Color color = new Color(rgb1[0] * ratio + rgb2[0] * inverse, rgb1[1] * ratio + rgb2[1] * inverse, rgb1[2] * ratio + rgb2[2] * inverse);
        return color;
    }
}

