/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.task;

import generic.concurrent.GThreadPool;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.framework.task.GTaskManager;
import ghidra.util.exception.AssertException;
import java.util.Map;
import java.util.WeakHashMap;

public class GTaskManagerFactory {
    private static Map<UndoableDomainObject, GTaskManager> map = new WeakHashMap<UndoableDomainObject, GTaskManager>();

    public static GTaskManager getTaskManager(UndoableDomainObject domainObject) {
        if (domainObject.isClosed()) {
            throw new AssertException("Attempted to get a TaskManger for a closed domain object");
        }
        GTaskManager gTaskManager = map.get(domainObject);
        if (gTaskManager == null) {
            GThreadPool sharedThreadPool = GThreadPool.getSharedThreadPool((String)"Program Thread");
            gTaskManager = new GTaskManager(domainObject, sharedThreadPool);
            map.put(domainObject, gTaskManager);
        }
        return gTaskManager;
    }

    static void domainObjectClosed(UndoableDomainObject domainObject) {
        map.remove(domainObject);
    }
}

