/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.protocol.ghidra;

import ghidra.framework.client.ClientUtil;
import ghidra.framework.client.NotConnectedException;
import ghidra.framework.protocol.ghidra.GhidraProtocolConnector;
import ghidra.framework.protocol.ghidra.GhidraURL;
import ghidra.util.Msg;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public class DefaultGhidraProtocolConnector
extends GhidraProtocolConnector {
    private boolean readOnly;

    DefaultGhidraProtocolConnector(URL ghidraURL) throws MalformedURLException {
        super(ghidraURL);
    }

    @Override
    public boolean isReadOnly() throws NotConnectedException {
        if (this.responseCode == -1) {
            throw new NotConnectedException("not connected");
        }
        return this.readOnly;
    }

    @Override
    public int connect(boolean readOnlyAccess) throws IOException {
        if (this.responseCode != -1) {
            throw new IllegalStateException("already connected");
        }
        this.readOnly = readOnlyAccess;
        this.responseCode = 404;
        this.repositoryServerAdapter = ClientUtil.getRepositoryServer((String)this.url.getHost(), (int)this.url.getPort(), (boolean)true);
        if (this.repositoryName == null) {
            this.responseCode = 200;
            return this.responseCode;
        }
        this.repositoryAdapter = this.repositoryServerAdapter.getRepository(this.repositoryName);
        this.repositoryAdapter.connect();
        if (this.repositoryAdapter.isConnected()) {
            this.responseCode = 200;
            if (!this.repositoryAdapter.getUser().hasWritePermission() && !this.readOnly) {
                this.readOnly = true;
                Msg.warn((Object)this, (Object)("User does not have write permission for repository: " + this.repositoryName));
            }
            this.resolveItemPath();
        } else {
            this.responseCode = 401;
        }
        return this.responseCode;
    }

    @Override
    protected URL getRepositoryRootGhidraURL() {
        if (this.repositoryName != null) {
            return GhidraURL.makeURL(this.url.getHost(), this.url.getPort(), this.repositoryName);
        }
        return null;
    }
}

