/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.project;

import ghidra.framework.ToolUtils;
import ghidra.framework.model.ToolChest;
import ghidra.framework.model.ToolChestChangeListener;
import ghidra.framework.model.ToolTemplate;
import ghidra.util.SystemUtilities;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

class ToolChestImpl
implements ToolChest {
    private List<ToolChestChangeListener> listeners;
    private Map<String, ToolTemplate> map = ToolUtils.loadUserTools();

    ToolChestImpl() {
        this.listeners = new ArrayList<ToolChestChangeListener>(3);
    }

    @Override
    public void addToolChestChangeListener(ToolChestChangeListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    @Override
    public void removeToolChestChangeListener(ToolChestChangeListener l) {
        if (this.listeners.contains(l)) {
            this.listeners.remove(l);
        }
    }

    @Override
    public ToolTemplate getToolTemplate(String toolName) {
        return this.map.get(toolName);
    }

    @Override
    public ToolTemplate[] getToolTemplates() {
        Collection<ToolTemplate> c = this.map.values();
        ToolTemplate[] templates = new ToolTemplate[c.size()];
        c.toArray(templates);
        return templates;
    }

    @Override
    public int getToolCount() {
        return this.map.size();
    }

    @Override
    public boolean remove(String name) {
        File toolFile = ToolUtils.getToolFile(name);
        boolean removed = toolFile.delete();
        if (!removed && toolFile.exists()) {
            return false;
        }
        this.map.remove(name);
        SystemUtilities.runSwingNow(() -> {
            ToolChestChangeListener[] tcListeners = new ToolChestChangeListener[this.listeners.size()];
            this.listeners.toArray(tcListeners);
            for (int l = 0; l < tcListeners.length; ++l) {
                tcListeners[l].toolRemoved(name);
            }
        });
        return true;
    }

    @Override
    public boolean replaceToolTemplate(ToolTemplate template) {
        return this.doAddToolTemplate(template);
    }

    @Override
    public boolean addToolTemplate(ToolTemplate template) {
        template.setName(ToolUtils.getUniqueToolName(template));
        return this.doAddToolTemplate(template);
    }

    private boolean doAddToolTemplate(ToolTemplate template) {
        if (!ToolUtils.writeToolTemplate(template)) {
            return false;
        }
        this.map.put(template.getName(), template);
        SystemUtilities.runSwingNow(() -> {
            for (ToolChestChangeListener listener : this.listeners) {
                listener.toolTemplateAdded(template);
            }
        });
        return true;
    }

    public String toString() {
        return "Project Tool Chest at " + ToolUtils.getUserToolsDirectory();
    }
}

