/*
 * Decompiled with CFR 0.152.
 */
package ghidra.javaclass.format.attributes;

import ghidra.app.util.bin.BinaryReader;
import ghidra.javaclass.format.attributes.AbstractAttributeInfo;
import ghidra.javaclass.format.attributes.AnnotationDefaultAttribute;
import ghidra.javaclass.format.attributes.BootstrapMethodsAttribute;
import ghidra.javaclass.format.attributes.CodeAttribute;
import ghidra.javaclass.format.attributes.ConstantValueAttribute;
import ghidra.javaclass.format.attributes.DeprecatedAttribute;
import ghidra.javaclass.format.attributes.EnclosingMethodAttribute;
import ghidra.javaclass.format.attributes.ExceptionsAttribute;
import ghidra.javaclass.format.attributes.InnerClassesAttribute;
import ghidra.javaclass.format.attributes.LineNumberTableAttribute;
import ghidra.javaclass.format.attributes.LocalVariableTableAttribute;
import ghidra.javaclass.format.attributes.LocalVariableTypeTableAttribute;
import ghidra.javaclass.format.attributes.ModuleAttribute;
import ghidra.javaclass.format.attributes.ModuleMainClassAttribute;
import ghidra.javaclass.format.attributes.ModulePackagesAttribute;
import ghidra.javaclass.format.attributes.NestHostAttribute;
import ghidra.javaclass.format.attributes.NestMembersAttribute;
import ghidra.javaclass.format.attributes.RuntimeInvisibleAnnotationsAttribute;
import ghidra.javaclass.format.attributes.RuntimeParameterAnnotationsAttribute;
import ghidra.javaclass.format.attributes.RuntimeVisibleAnnotationsAttribute;
import ghidra.javaclass.format.attributes.SignatureAttribute;
import ghidra.javaclass.format.attributes.SourceDebugExtensionAttribute;
import ghidra.javaclass.format.attributes.SourceFileAttribute;
import ghidra.javaclass.format.attributes.StackMapTableAttribute;
import ghidra.javaclass.format.attributes.SyntheticAttribute;
import ghidra.javaclass.format.constantpool.AbstractConstantPoolInfoJava;
import ghidra.javaclass.format.constantpool.ConstantPoolUtf8Info;
import java.io.IOException;

public class AttributeFactory {
    public static AbstractAttributeInfo get(BinaryReader reader, AbstractConstantPoolInfoJava[] constantPool) throws IOException {
        short attributeNameIndex = reader.readShort(reader.getPointerIndex());
        if (attributeNameIndex < 1 || attributeNameIndex >= constantPool.length) {
            throw new RuntimeException("invalid index");
        }
        if (!(constantPool[attributeNameIndex] instanceof ConstantPoolUtf8Info)) {
            throw new RuntimeException();
        }
        ConstantPoolUtf8Info utf8 = (ConstantPoolUtf8Info)constantPool[attributeNameIndex];
        switch (utf8.getString()) {
            case "AnnotationDefault": {
                return new AnnotationDefaultAttribute(reader);
            }
            case "BootstrapMethods": {
                return new BootstrapMethodsAttribute(reader);
            }
            case "Code": {
                return new CodeAttribute(reader, constantPool);
            }
            case "ConstantValue": {
                return new ConstantValueAttribute(reader);
            }
            case "Deprecated": {
                return new DeprecatedAttribute(reader);
            }
            case "EnclosingMethod": {
                return new EnclosingMethodAttribute(reader);
            }
            case "Exceptions": {
                return new ExceptionsAttribute(reader);
            }
            case "InnerClasses": {
                return new InnerClassesAttribute(reader);
            }
            case "LineNumberTable": {
                return new LineNumberTableAttribute(reader);
            }
            case "LocalVariableTable": {
                return new LocalVariableTableAttribute(reader, constantPool);
            }
            case "LocalVariableTypeTable": {
                return new LocalVariableTypeTableAttribute(reader);
            }
            case "ModuleMainClass": {
                return new ModuleMainClassAttribute(reader);
            }
            case "ModulePackages": {
                return new ModulePackagesAttribute(reader);
            }
            case "NestHost": {
                return new NestHostAttribute(reader);
            }
            case "NestMembers": {
                return new NestMembersAttribute(reader);
            }
            case "RuntimeInvisibleAnnotations": {
                return new RuntimeInvisibleAnnotationsAttribute(reader);
            }
            case "RuntimeInvisibleParameterAnnotations": {
                return new RuntimeParameterAnnotationsAttribute(reader, false);
            }
            case "RuntimeVisibleAnnotations": {
                return new RuntimeVisibleAnnotationsAttribute(reader);
            }
            case "RuntimeVisibleParameterAnnotations": {
                return new RuntimeParameterAnnotationsAttribute(reader, true);
            }
            case "Signature": {
                return new SignatureAttribute(reader);
            }
            case "SourceDebugExtension": {
                return new SourceDebugExtensionAttribute(reader);
            }
            case "SourceFile": {
                return new SourceFileAttribute(reader);
            }
            case "StackMapTable": {
                return new StackMapTableAttribute(reader);
            }
            case "Synthetic": {
                return new SyntheticAttribute(reader);
            }
            case "Module": {
                return new ModuleAttribute(reader);
            }
        }
        throw new RuntimeException("Unknown attribute type: " + utf8.getString());
    }
}

