/*
 * Decompiled with CFR 0.152.
 */
package help;

import help.TOCItemProvider;
import help.validator.LinkDatabase;
import help.validator.model.TOCItem;
import help.validator.model.TOCItemDefinition;
import help.validator.model.TOCItemExternal;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class OverlayHelpTree {
    private Map<String, Set<TOCItem>> parentToChildrenMap = new HashMap<String, Set<TOCItem>>();
    private TOCItem rootItem;
    private OverlayNode rootNode;
    private final LinkDatabase linkDatabase;
    private static final Comparator<OverlayNode> CHILD_SORT_COMPARATOR = new Comparator<OverlayNode>(){

        @Override
        public int compare(OverlayNode ov1, OverlayNode ov2) {
            TOCItem o1 = ov1.getTOCItemDefinition();
            TOCItem o2 = ov2.getTOCItemDefinition();
            if (!o1.getSortPreference().equals(o2.getSortPreference())) {
                return o1.getSortPreference().compareTo(o2.getSortPreference());
            }
            String text1 = o1.getTextAttribute();
            String text2 = o2.getTextAttribute();
            if (text1 == null && text2 == null) {
                return 0;
            }
            if (text1 == null) {
                return 1;
            }
            if (text2 == null) {
                return -1;
            }
            return text1.compareTo(text2);
        }
    };

    public OverlayHelpTree(TOCItemProvider tocItemProvider, LinkDatabase linkDatabase) {
        this.linkDatabase = linkDatabase;
        for (TOCItemExternal external : tocItemProvider.getTOCItemExternalsByDisplayMapping().values()) {
            this.addExternalTOCItem(external);
        }
        for (TOCItemDefinition definition : tocItemProvider.getTOCItemDefinitionsByIDMapping().values()) {
            this.addSourceTOCItem(definition);
        }
    }

    private void addExternalTOCItem(TOCItem item) {
        String parentID;
        TOCItem parent = item.getParent();
        String string = parentID = parent == null ? null : parent.getIDAttribute();
        if (parentID == null) {
            if (this.rootItem != null) {
                if (!item.isEquivalent(this.rootItem)) {
                    throw new IllegalArgumentException("Cannot define more than one root node:\n\t" + item + ", but there already exists\n\t" + this.rootItem);
                }
            } else {
                this.rootItem = item;
            }
            return;
        }
        this.doAddTOCIItem(item);
    }

    private void addSourceTOCItem(TOCItem item) {
        String parentID;
        TOCItem parent = item.getParent();
        String string = parentID = parent == null ? null : parent.getIDAttribute();
        if (parentID == null) {
            if (this.rootItem != null) {
                if (this.rootItem.getSourceFile().equals(item.getSourceFile())) {
                    throw new IllegalArgumentException("Cannot define more than one root node in the same file:\n\t" + item + ",\nbut there already exists\n\t" + this.rootItem);
                }
            } else {
                this.rootItem = item;
            }
            return;
        }
        this.doAddTOCIItem(item);
    }

    private void doAddTOCIItem(TOCItem item) {
        TOCItem parent = item.getParent();
        String parentID = parent == null ? null : parent.getIDAttribute();
        Set<TOCItem> set = this.parentToChildrenMap.get(parentID);
        if (set == null) {
            set = new LinkedHashSet<TOCItem>();
            this.parentToChildrenMap.put(parentID, set);
        }
        set.add(item);
    }

    public void printTreeForID(Path outputFile, String sourceFileID) throws IOException {
        if (Files.exists(outputFile, new LinkOption[0])) {
            Files.delete(outputFile);
        }
        OutputStreamWriter osw = new OutputStreamWriter(Files.newOutputStream(outputFile, new OpenOption[0]));
        PrintWriter writer = new PrintWriter(new BufferedWriter(osw));
        this.printTreeForID(writer, sourceFileID);
    }

    void printTreeForID(PrintWriter writer, String sourceFileID) {
        this.initializeTree();
        try {
            writer.println("<?xml version='1.0' encoding='ISO-8859-1' ?>");
            writer.println("<!-- Auto-generated on " + new Date().toString() + " -->");
            writer.println();
            writer.println("<toc version=\"2.0\">");
            this.printContents(sourceFileID, writer);
            writer.println("</toc>");
        }
        finally {
            writer.close();
        }
    }

    private void printContents(String sourceFileID, PrintWriter writer) {
        if (this.rootNode == null) {
            return;
        }
        this.rootNode.print(sourceFileID, writer, 0);
    }

    private boolean initializeTree() {
        if (this.rootNode != null) {
            return true;
        }
        if (this.rootItem == null) {
            return false;
        }
        OverlayNode newRootNode = new OverlayNode(null, this.rootItem);
        this.buildChildren(newRootNode);
        if (!this.parentToChildrenMap.isEmpty()) {
            throw new RuntimeException("Unresolved definitions in tree!");
        }
        this.rootNode = newRootNode;
        return true;
    }

    private void buildChildren(OverlayNode node) {
        String definitionID = node.getDefinitionID();
        Set<TOCItem> children = this.parentToChildrenMap.remove(definitionID);
        if (children == null) {
            return;
        }
        for (TOCItem child : children) {
            OverlayNode childNode = new OverlayNode(node, child);
            node.addChild(childNode);
            this.buildChildren(childNode);
        }
    }

    private class OverlayNode {
        private final TOCItem item;
        private final OverlayNode parentNode;
        private Set<String> fileIDs = new HashSet<String>();
        private Set<OverlayNode> children = new TreeSet<OverlayNode>(CHILD_SORT_COMPARATOR);

        public OverlayNode(OverlayNode parentNode, TOCItem rootItem) {
            this.parentNode = parentNode;
            this.item = rootItem;
            Path sourceFile = rootItem.getSourceFile();
            String fileID = sourceFile.toUri().toString();
            this.addFileIDToTreePath(fileID);
        }

        void print(String sourceFileID, PrintWriter writer, int indentLevel) {
            if (!this.fileIDs.contains(sourceFileID)) {
                return;
            }
            writer.println(this.item.generateTOCItemTag(OverlayHelpTree.this.linkDatabase, this.children.isEmpty(), indentLevel));
            if (!this.children.isEmpty()) {
                for (OverlayNode node : this.children) {
                    node.print(sourceFileID, writer, indentLevel + 1);
                }
                writer.println(this.item.generateEndTag(indentLevel));
            }
        }

        void addChild(OverlayNode overlayNode) {
            this.children.add(overlayNode);
        }

        String getDefinitionID() {
            return this.item.getIDAttribute();
        }

        private void addFileIDToTreePath(String fileID) {
            this.fileIDs.add(fileID);
            if (this.parentNode != null) {
                this.parentNode.addFileIDToTreePath(fileID);
            }
        }

        TOCItem getTOCItemDefinition() {
            return this.item;
        }

        public String toString() {
            return this.item.toString();
        }
    }
}

