/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.analyzers;

import generic.hash.FNV1a64MessageDigest;
import generic.stl.Pair;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CodeUnitIterator;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitorAdapter;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.PriorityQueue;

public class FuncRecord
implements Comparable<FuncRecord> {
    public long hashValue;
    public String funcName;
    public Function func;
    private static long initHash = 305419896L;
    public ArrayList<FuncRecord> children;
    public ArrayList<Address> calls;

    public FuncRecord() {
        this.func = null;
        this.funcName = "";
        this.hashValue = initHash;
        this.children = new ArrayList();
        this.calls = new ArrayList();
    }

    public FuncRecord(Function func) throws CancelledException {
        this.func = func;
        this.funcName = func.toString();
        this.hashValue = initHash;
        this.children = new ArrayList();
        this.calls = new ArrayList();
        Listing listo = func.getProgram().getListing();
        HashSet<AddressRange> seenRanges = new HashSet<AddressRange>();
        AddressSetView body = func.getBody();
        AddressRange initRange = body.getRangeContaining(func.getEntryPoint());
        PriorityQueue<AddressRange> q = new PriorityQueue<AddressRange>();
        seenRanges.add(initRange);
        q.add(initRange);
        FunctionManager fMan = func.getProgram().getFunctionManager();
        FNV1a64MessageDigest digest = new FNV1a64MessageDigest();
        while (q.peek() != null) {
            AddressRange curRange = (AddressRange)q.remove();
            AddressSet curView = new AddressSet(curRange);
            CodeUnitIterator units = listo.getCodeUnits((AddressSetView)curView, true);
            while (units.hasNext()) {
                CodeUnit unit = units.next();
                if (!(unit instanceof Instruction)) continue;
                Instruction instr = (Instruction)unit;
                Object[] localCalls = instr.getFlows();
                if (localCalls != null && localCalls.length > 1) {
                    Arrays.sort(localCalls);
                }
                if (localCalls != null) {
                    for (Object call : localCalls) {
                        Function possibleCall = fMan.getFunctionContaining((Address)call);
                        if (possibleCall == null || !possibleCall.getEntryPoint().equals(call)) continue;
                        this.calls.add((Address)call);
                    }
                }
                try {
                    byte[] toHash = instr.getBytes();
                    for (int opNum = 0; opNum < instr.getNumOperands(); ++opNum) {
                        Object[] opObs;
                        for (Object ob : opObs = instr.getOpObjects(opNum)) {
                            if (ob instanceof Register || ob instanceof Character) continue;
                            byte[] mbytes = instr.getPrototype().getOperandValueMask(opNum).getBytes();
                            for (int i = 0; i < mbytes.length; ++i) {
                                toHash[i] = (byte)(toHash[i] & (0xFF ^ mbytes[i]));
                            }
                        }
                    }
                    byte[] totalToHash = new byte[toHash.length + 8];
                    for (int bytt = 0; bytt < 8; ++bytt) {
                        totalToHash[bytt] = (byte)((this.hashValue >>> 8 * (7 - bytt)) % 256L);
                    }
                    for (int index = 0; index < toHash.length; ++index) {
                        totalToHash[8 + index] = toHash[index];
                    }
                    digest.reset();
                    digest.update(totalToHash, TaskMonitorAdapter.DUMMY_MONITOR);
                    this.hashValue = digest.digestLong();
                }
                catch (MemoryAccessException e1) {
                    e1.printStackTrace();
                }
                Object[] flows = instr.getFlows();
                if (flows.length > 1) {
                    Arrays.sort(flows);
                }
                for (Object flow : flows) {
                    AddressRange flowRange = body.getRangeContaining((Address)flow);
                    if (flowRange == null || seenRanges.contains(flowRange)) continue;
                    q.add(flowRange);
                    seenRanges.add(flowRange);
                }
            }
        }
    }

    public String toString() {
        Object result = "";
        result = (String)result + this.funcName;
        result = (String)result + "," + this.hashValue;
        return result;
    }

    @Override
    public int compareTo(FuncRecord o) {
        int first = Long.valueOf(this.hashValue).compareTo(o.hashValue);
        if (first != 0) {
            return first;
        }
        return this.funcName.compareTo(o.funcName);
    }

    public ArrayList<Pair<String, String>> restoreXml(XmlPullParser parser) {
        ArrayList<Pair<String, String>> edges = new ArrayList<Pair<String, String>>();
        XmlElement el = parser.start(new String[]{"funcRec"});
        this.funcName = el.getAttribute("funcName");
        String hashValStr = el.getAttribute("hashVal");
        this.hashValue = Long.parseLong(hashValStr);
        while (parser.peek().isStart()) {
            XmlElement elt = parser.start(new String[]{"child"});
            edges.add((Pair<String, String>)new Pair((Object)this.funcName, (Object)elt.getAttribute("name")));
            parser.end();
        }
        parser.end();
        return edges;
    }

    public void saveXml(Writer fwrite) throws IOException {
        StringBuilder buf = new StringBuilder();
        buf.append("  <funcRec");
        buf.append(" funcName=\"");
        SpecXmlUtils.xmlEscape((StringBuilder)buf, (String)this.funcName);
        buf.append("\"");
        buf.append(" hashVal=\"" + this.hashValue + "\"");
        buf.append(">\n");
        fwrite.append(buf.toString());
        buf = new StringBuilder();
        for (FuncRecord kid : this.children) {
            buf.append("   <child name=\"");
            SpecXmlUtils.xmlEscape((StringBuilder)buf, (String)kid.funcName);
            buf.append("\"/>\n");
        }
        buf.append("  </funcRec>\n");
        fwrite.append(buf.toString());
    }
}

