(declare (block) (standard-bindings) (extended-bindings))
(begin
  (declare (not safe))
  (define std/text/utf8#string->utf8__%
    (lambda (_str97575_ _start97576_ _end97577_)
      (if (string? _str97575_)
          (std/text/utf8#utf8-encode _str97575_ _start97576_ _end97577_)
          (error '"Bad argument; expected string" _str97575_))))
  (define std/text/utf8#string->utf8__0
    (lambda (_str97582_)
      (let* ((_start97584_ '0) (_end97586_ (string-length _str97582_)))
        (std/text/utf8#string->utf8__% _str97582_ _start97584_ _end97586_))))
  (define std/text/utf8#string->utf8__1
    (lambda (_str97588_ _start97589_)
      (let ((_end97591_ (string-length _str97588_)))
        (std/text/utf8#string->utf8__% _str97588_ _start97589_ _end97591_))))
  (define std/text/utf8#string->utf8
    (lambda _g97597_
      (let ((_g97596_ (length _g97597_)))
        (cond ((##fx= _g97596_ 1)
               (apply std/text/utf8#string->utf8__0 _g97597_))
              ((##fx= _g97596_ 2)
               (apply std/text/utf8#string->utf8__1 _g97597_))
              ((##fx= _g97596_ 3)
               (apply std/text/utf8#string->utf8__% _g97597_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/text/utf8#string->utf8
                _g97597_))))))
  (define std/text/utf8#string-utf8-length__%
    (lambda (_str97552_ _start97553_ _end97554_)
      (if (string? _str97552_)
          (std/text/utf8#utf8-encode-length _str97552_ _start97553_ _end97554_)
          (error '"Bad argument; expected string" _str97552_))))
  (define std/text/utf8#string-utf8-length__0
    (lambda (_str97559_)
      (let* ((_start97561_ '0) (_end97563_ (string-length _str97559_)))
        (std/text/utf8#string-utf8-length__%
         _str97559_
         _start97561_
         _end97563_))))
  (define std/text/utf8#string-utf8-length__1
    (lambda (_str97565_ _start97566_)
      (let ((_end97568_ (string-length _str97565_)))
        (std/text/utf8#string-utf8-length__%
         _str97565_
         _start97566_
         _end97568_))))
  (define std/text/utf8#string-utf8-length
    (lambda _g97599_
      (let ((_g97598_ (length _g97599_)))
        (cond ((##fx= _g97598_ 1)
               (apply std/text/utf8#string-utf8-length__0 _g97599_))
              ((##fx= _g97598_ 2)
               (apply std/text/utf8#string-utf8-length__1 _g97599_))
              ((##fx= _g97598_ 3)
               (apply std/text/utf8#string-utf8-length__% _g97599_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/text/utf8#string-utf8-length
                _g97599_))))))
  (define std/text/utf8#utf8->string__%
    (lambda (_u8v97529_ _start97530_ _end97531_)
      (if (u8vector? _u8v97529_)
          (std/text/utf8#utf8-decode _u8v97529_ _start97530_ _end97531_)
          (error '"Bad argument; expected u8vector" _u8v97529_))))
  (define std/text/utf8#utf8->string__0
    (lambda (_u8v97536_)
      (let* ((_start97538_ '0) (_end97540_ (u8vector-length _u8v97536_)))
        (std/text/utf8#utf8->string__% _u8v97536_ _start97538_ _end97540_))))
  (define std/text/utf8#utf8->string__1
    (lambda (_u8v97542_ _start97543_)
      (let ((_end97545_ (u8vector-length _u8v97542_)))
        (std/text/utf8#utf8->string__% _u8v97542_ _start97543_ _end97545_))))
  (define std/text/utf8#utf8->string
    (lambda _g97601_
      (let ((_g97600_ (length _g97601_)))
        (cond ((##fx= _g97600_ 1)
               (apply std/text/utf8#utf8->string__0 _g97601_))
              ((##fx= _g97600_ 2)
               (apply std/text/utf8#utf8->string__1 _g97601_))
              ((##fx= _g97600_ 3)
               (apply std/text/utf8#utf8->string__% _g97601_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/text/utf8#utf8->string
                _g97601_))))))
  (define std/text/utf8#utf8-encode
    (lambda (_str97515_ _start97516_ _end97517_)
      (let* ((_slen97519_ (fx- _end97517_ _start97516_))
             (_u8vlen97521_ (##fx* _slen97519_ '4))
             (_u8v97523_ (make-u8vector _u8vlen97521_))
             (_count97525_
              (std/text/utf8#utf8-encode!
               _str97515_
               _u8v97523_
               _start97516_
               _end97517_)))
        (##u8vector-shrink! _u8v97523_ _count97525_)
        _u8v97523_)))
  (define std/text/utf8#utf8-encode-length
    (lambda (_str97501_ _start97502_ _end97503_)
      (let _lp97505_ ((_i97507_ _start97502_) (_r97508_ '0))
        (if (##fx< _i97507_ _end97503_)
            (let* ((_char97510_ (##string-ref _str97501_ _i97507_))
                   (_clen97512_ (std/text/utf8#utf8-char-length _char97510_)))
              (_lp97505_ (##fx+ _i97507_ '1) (##fx+ _r97508_ _clen97512_)))
            _r97508_))))
  (define std/text/utf8#utf8-char-length
    (lambda (_char97497_)
      (let ((_c97499_ (##char->integer _char97497_)))
        (if (##fx<= _c97499_ '127)
            '1
            (if (##fx<= _c97499_ '2047)
                '2
                (if (##fx<= _c97499_ '65535) '3 '4))))))
  (define std/text/utf8#utf8-encode!
    (lambda (_str97482_ _u8v97483_ _start97484_ _end97485_)
      (let _lp97487_ ((_i97489_ _start97484_) (_j97490_ '0))
        (if (##fx< _i97489_ _end97485_)
            (let* ((_char97492_ (##string-ref _str97482_ _i97489_))
                   (_c97494_ (##char->integer _char97492_)))
              (if (##fx<= _c97494_ '127)
                  (begin
                    (##u8vector-set! _u8v97483_ _j97490_ _c97494_)
                    (_lp97487_ (##fx+ _i97489_ '1) (##fx+ _j97490_ '1)))
                  (if (##fx<= _c97494_ '2047)
                      (begin
                        (##u8vector-set!
                         _u8v97483_
                         _j97490_
                         (##fxior '192
                                  (##fxarithmetic-shift-right _c97494_ '6)))
                        (##u8vector-set!
                         _u8v97483_
                         (##fx+ _j97490_ '1)
                         (##fxior '128 (##fxand _c97494_ '63)))
                        (_lp97487_ (##fx+ _i97489_ '1) (##fx+ _j97490_ '2)))
                      (if (##fx<= _c97494_ '65535)
                          (begin
                            (##u8vector-set!
                             _u8v97483_
                             _j97490_
                             (##fxior '224
                                      (##fxarithmetic-shift-right
                                       _c97494_
                                       '12)))
                            (##u8vector-set!
                             _u8v97483_
                             (##fx+ _j97490_ '1)
                             (##fxior '128
                                      (##fxand (##fxarithmetic-shift-right
                                                _c97494_
                                                '6)
                                               '63)))
                            (##u8vector-set!
                             _u8v97483_
                             (##fx+ _j97490_ '2)
                             (##fxior '128 (##fxand _c97494_ '63)))
                            (_lp97487_
                             (##fx+ _i97489_ '1)
                             (##fx+ _j97490_ '3)))
                          (begin
                            (##u8vector-set!
                             _u8v97483_
                             _j97490_
                             (##fxior '240
                                      (##fxarithmetic-shift-right
                                       _c97494_
                                       '18)))
                            (##u8vector-set!
                             _u8v97483_
                             (##fx+ _j97490_ '1)
                             (##fxior '128
                                      (##fxand (##fxarithmetic-shift-right
                                                _c97494_
                                                '12)
                                               '63)))
                            (##u8vector-set!
                             _u8v97483_
                             (##fx+ _j97490_ '2)
                             (##fxior '128
                                      (##fxand (##fxarithmetic-shift-right
                                                _c97494_
                                                '6)
                                               '63)))
                            (##u8vector-set!
                             _u8v97483_
                             (##fx+ _j97490_ '3)
                             (##fxior '128 (##fxand _c97494_ '63)))
                            (_lp97487_
                             (##fx+ _i97489_ '1)
                             (##fx+ _j97490_ '4)))))))
            _j97490_))))
  (define std/text/utf8#utf8-decode
    (lambda (_u8v97471_ _start97472_ _end97473_)
      (let* ((_u8vlen97475_ (fx- _end97473_ _start97472_))
             (_str97477_ (make-string _u8vlen97475_))
             (_slen97479_
              (std/text/utf8#utf8-decode!
               _u8v97471_
               _str97477_
               _start97472_
               _end97473_)))
        (##string-shrink! _str97477_ _slen97479_)
        _str97477_)))
  (define std/text/utf8#utf8-decode!
    (lambda (_u8v97427_ _str97428_ _start97429_ _end97430_)
      (let _lp97432_ ((_i97434_ _start97429_) (_j97435_ '0))
        (if (##fx< _i97434_ _end97430_)
            (let ((_byte97437_ (##u8vector-ref _u8v97427_ _i97434_)))
              (if (##fx<= _byte97437_ '127)
                  (let ((_char97439_ (##integer->char _byte97437_)))
                    (##string-set! _str97428_ _j97435_ _char97439_)
                    (_lp97432_ (##fx+ _i97434_ '1) (##fx+ _j97435_ '1)))
                  (if (##fx<= _byte97437_ '223)
                      (let* ((_i+297441_ (##fx+ _i97434_ '2))
                             (_g97602_
                              (if (##fx<= _i+297441_ _end97430_)
                                  '#!void
                                  (std/error#raise-io-error
                                   'utf8-decode!
                                   '"incomplete character"
                                   _byte97437_)))
                             (_byte297444_
                              (##u8vector-ref _u8v97427_ (##fx+ _i97434_ '1)))
                             (_char97446_
                              (##integer->char
                               (##fxior (##fxarithmetic-shift-left
                                         (##fxand _byte97437_ '31)
                                         '6)
                                        (##fxand _byte297444_ '63)))))
                        (##string-set! _str97428_ _j97435_ _char97446_)
                        (_lp97432_ _i+297441_ (##fx+ _j97435_ '1)))
                      (if (##fx<= _byte97437_ '239)
                          (let* ((_i+397449_ (##fx+ _i97434_ '3))
                                 (_g97603_
                                  (if (##fx<= _i+397449_ _end97430_)
                                      '#!void
                                      (std/error#raise-io-error
                                       'utf8-decode!
                                       '"incomplete character"
                                       _byte97437_)))
                                 (_byte297452_
                                  (##u8vector-ref
                                   _u8v97427_
                                   (##fx+ _i97434_ '1)))
                                 (_byte397454_
                                  (##u8vector-ref
                                   _u8v97427_
                                   (##fx+ _i97434_ '2)))
                                 (_char97456_
                                  (##integer->char
                                   (##fxior (##fxarithmetic-shift-left
                                             (##fxand _byte97437_ '15)
                                             '12)
                                            (##fxarithmetic-shift-left
                                             (##fxand _byte297452_ '63)
                                             '6)
                                            (##fxand _byte397454_ '63)))))
                            (##string-set! _str97428_ _j97435_ _char97456_)
                            (_lp97432_ _i+397449_ (##fx+ _j97435_ '1)))
                          (if (##fx<= _byte97437_ '244)
                              (let* ((_i+497459_ (##fx+ _i97434_ '4))
                                     (_g97604_
                                      (if (##fx<= _i+497459_ _end97430_)
                                          '#!void
                                          (std/error#raise-io-error
                                           'utf8-decode!
                                           '"incomplete character"
                                           _byte97437_)))
                                     (_byte297462_
                                      (##u8vector-ref
                                       _u8v97427_
                                       (##fx+ _i97434_ '1)))
                                     (_byte397464_
                                      (##u8vector-ref
                                       _u8v97427_
                                       (##fx+ _i97434_ '2)))
                                     (_byte497466_
                                      (##u8vector-ref
                                       _u8v97427_
                                       (##fx+ _i97434_ '3)))
                                     (_char97468_
                                      (##integer->char
                                       (##fxior (##fxarithmetic-shift-left
                                                 (##fxand _byte97437_ '7)
                                                 '18)
                                                (##fxarithmetic-shift-left
                                                 (##fxand _byte297462_ '63)
                                                 '12)
                                                (##fxarithmetic-shift-left
                                                 (##fxand _byte397464_ '63)
                                                 '6)
                                                (##fxand _byte497466_ '63)))))
                                (##string-set! _str97428_ _j97435_ _char97468_)
                                (_lp97432_ _i+497459_ (##fx+ _j97435_ '1)))
                              (begin
                                (##string-set! _str97428_ _j97435_ '#\xfffd)
                                (_lp97432_
                                 (##fx+ _i97434_ '1)
                                 (##fx+ _j97435_ '1))))))))
            _j97435_)))))
