/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.socket.DatagramChannel;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;
import org.traccar.protocol.EelinkProtocolEncoder;

public class EelinkProtocolDecoder
extends BaseProtocolDecoder {
    public static final int MSG_LOGIN = 1;
    public static final int MSG_GPS = 2;
    public static final int MSG_HEARTBEAT = 3;
    public static final int MSG_ALARM = 4;
    public static final int MSG_STATE = 5;
    public static final int MSG_SMS = 6;
    public static final int MSG_OBD = 7;
    public static final int MSG_DOWNLINK = 128;
    public static final int MSG_DATA = 129;
    public static final int MSG_NORMAL = 18;
    public static final int MSG_WARNING = 20;
    public static final int MSG_REPORT = 21;
    public static final int MSG_COMMAND = 22;
    public static final int MSG_OBD_DATA = 23;
    public static final int MSG_OBD_BODY = 24;
    public static final int MSG_OBD_CODE = 25;
    public static final int MSG_CAMERA_INFO = 30;
    public static final int MSG_CAMERA_DATA = 31;
    private static final Pattern PATTERN = new PatternBuilder().text("Lat:").number("([NS])(d+.d+)").any().text("Lon:").number("([EW])(d+.d+)").any().text("Course:").number("(d+.d+)").any().text("Speed:").number("(d+.d+)").any().expression("Date ?Time:").number("(dddd)-(dd)-(dd) ").number("(dd):(dd):(dd)").compile();

    public EelinkProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private String decodeAlarm(Short value) {
        switch (value) {
            case 1: {
                return "powerOff";
            }
            case 2: {
                return "sos";
            }
            case 3: {
                return "lowBattery";
            }
            case 4: {
                return "vibration";
            }
            case 8: 
            case 9: {
                return "gpsAntennaCut";
            }
            case 129: {
                return "lowspeed";
            }
            case 130: {
                return "overspeed";
            }
            case 131: {
                return "geofenceEnter";
            }
            case 132: {
                return "geofenceExit";
            }
            case 133: {
                return "accident";
            }
            case 134: {
                return "fallDown";
            }
        }
        return null;
    }

    private void decodeStatus(Position position, int status) {
        if (BitUtil.check(status, 1)) {
            position.set("ignition", BitUtil.check(status, 2));
        }
        if (BitUtil.check(status, 3)) {
            position.set("armed", BitUtil.check(status, 4));
        }
        if (BitUtil.check(status, 5)) {
            position.set("blocked", !BitUtil.check(status, 6));
        }
        if (BitUtil.check(status, 7)) {
            position.set("charge", BitUtil.check(status, 8));
        }
        position.set("status", status);
    }

    private Position decodeOld(DeviceSession deviceSession, ByteBuf buf, int type, int index) {
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.set("index", index);
        position.setTime(new Date(buf.readUnsignedInt() * 1000L));
        position.setLatitude((double)buf.readInt() / 1800000.0);
        position.setLongitude((double)buf.readInt() / 1800000.0);
        position.setSpeed(UnitsConverter.knotsFromKph(buf.readUnsignedByte()));
        position.setCourse(buf.readUnsignedShort());
        position.setNetwork(new Network(CellTower.from(buf.readUnsignedShort(), buf.readUnsignedShort(), buf.readUnsignedShort(), buf.readUnsignedMedium())));
        position.setValid((buf.readUnsignedByte() & 1) != 0);
        if (type == 2) {
            if (buf.readableBytes() >= 2) {
                this.decodeStatus(position, buf.readUnsignedShort());
            }
            if (buf.readableBytes() >= 8) {
                position.set("battery", (double)buf.readUnsignedShort() * 0.001);
                position.set("rssi", buf.readUnsignedShort());
                position.set("adc1", buf.readUnsignedShort());
                position.set("adc2", buf.readUnsignedShort());
            }
        } else if (type == 4) {
            position.set("alarm", this.decodeAlarm(buf.readUnsignedByte()));
        } else if (type == 5) {
            short statusType = buf.readUnsignedByte();
            position.set("event", Integer.valueOf(statusType));
            if (statusType == 1 || statusType == 2 || statusType == 3) {
                buf.readUnsignedInt();
                if (buf.readableBytes() >= 2) {
                    this.decodeStatus(position, buf.readUnsignedShort());
                }
            }
        }
        return position;
    }

    private Position decodeNew(DeviceSession deviceSession, ByteBuf buf, int type, int index) {
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.set("index", index);
        position.setTime(new Date(buf.readUnsignedInt() * 1000L));
        short flags = buf.readUnsignedByte();
        if (BitUtil.check(flags, 0)) {
            position.setLatitude((double)buf.readInt() / 1800000.0);
            position.setLongitude((double)buf.readInt() / 1800000.0);
            position.setAltitude(buf.readShort());
            position.setSpeed(UnitsConverter.knotsFromKph(buf.readUnsignedShort()));
            position.setCourse(buf.readUnsignedShort());
            position.set("sat", buf.readUnsignedByte());
        } else {
            this.getLastLocation(position, position.getDeviceTime());
        }
        if (BitUtil.check(flags, 1)) {
            position.setNetwork(new Network(CellTower.from(buf.readUnsignedShort(), buf.readUnsignedShort(), buf.readUnsignedShort(), buf.readUnsignedInt(), buf.readUnsignedByte())));
        }
        if (BitUtil.check(flags, 2)) {
            buf.skipBytes(7);
        }
        if (BitUtil.check(flags, 3)) {
            buf.skipBytes(7);
        }
        if (BitUtil.check(flags, 4)) {
            buf.skipBytes(7);
        }
        if (BitUtil.check(flags, 5)) {
            buf.skipBytes(7);
        }
        if (BitUtil.check(flags, 6)) {
            buf.skipBytes(7);
        }
        if (type == 20) {
            position.set("alarm", this.decodeAlarm(buf.readUnsignedByte()));
        } else if (type == 21) {
            buf.readUnsignedByte();
        }
        if (type == 18 || type == 20 || type == 21) {
            int status = buf.readUnsignedShort();
            position.setValid(BitUtil.check(status, 0));
            if (BitUtil.check(status, 1)) {
                position.set("ignition", BitUtil.check(status, 2));
            }
            position.set("status", status);
        }
        if (type == 18) {
            if (buf.readableBytes() >= 2) {
                position.set("battery", (double)buf.readUnsignedShort() * 0.001);
            }
            if (buf.readableBytes() >= 4) {
                position.set("adc0", buf.readUnsignedShort());
                position.set("adc1", buf.readUnsignedShort());
            }
            if (buf.readableBytes() >= 4) {
                position.set("odometer", buf.readUnsignedInt());
            }
            if (buf.readableBytes() >= 4) {
                buf.readUnsignedShort();
                buf.readUnsignedShort();
            }
            if (buf.readableBytes() >= 4) {
                position.set("steps", buf.readUnsignedShort());
                buf.readUnsignedShort();
            }
            if (buf.readableBytes() >= 12) {
                position.set("temp1", (double)buf.readUnsignedShort() / 256.0);
                position.set("humidity", (double)buf.readUnsignedShort() * 0.1);
                position.set("illuminance", (double)buf.readUnsignedInt() / 256.0);
                position.set("co2", buf.readUnsignedInt());
            }
            if (buf.readableBytes() >= 2) {
                position.set("temp2", (double)buf.readShort() / 16.0);
            }
            if (buf.readableBytes() >= 2) {
                int count = buf.readUnsignedByte();
                buf.readUnsignedByte();
                for (int i = 1; i <= count; ++i) {
                    position.set("tag" + i + "Id", ByteBufUtil.hexDump((ByteBuf)buf.readSlice(6)));
                    buf.readUnsignedByte();
                    buf.readUnsignedByte();
                    buf.readUnsignedByte();
                    buf.readUnsignedByte();
                    position.set("tag" + i + "Battery", (double)buf.readUnsignedShort() * 0.001);
                    position.set("tag" + i + "Temp", (double)buf.readShort() / 256.0);
                    position.set("tag" + i + "Data", buf.readUnsignedShort());
                }
            }
        }
        return position;
    }

    private Position decodeResult(DeviceSession deviceSession, ByteBuf buf, int index) {
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.set("index", index);
        buf.readUnsignedByte();
        buf.readUnsignedInt();
        String sentence = buf.toString(StandardCharsets.UTF_8);
        Parser parser = new Parser(PATTERN, sentence);
        if (parser.matches()) {
            position.setValid(true);
            position.setLatitude(parser.nextCoordinate(Parser.CoordinateFormat.HEM_DEG));
            position.setLongitude(parser.nextCoordinate(Parser.CoordinateFormat.HEM_DEG));
            position.setCourse(parser.nextDouble());
            position.setSpeed(UnitsConverter.knotsFromKph(parser.nextDouble()));
            position.setTime(parser.nextDateTime());
        } else {
            this.getLastLocation(position, null);
            position.set("result", sentence);
        }
        return position;
    }

    private Position decodeObd(DeviceSession deviceSession, ByteBuf buf) {
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        this.getLastLocation(position, new Date(buf.readUnsignedInt() * 1000L));
        while (buf.readableBytes() > 0) {
            short pid = buf.readUnsignedByte();
            int value = buf.readInt();
            switch (pid) {
                case 137: {
                    position.set("fuelConsumption", value);
                    break;
                }
                case 138: {
                    position.set("odometer", (long)value * 1000L);
                    break;
                }
                case 139: {
                    position.set("fuel", value / 10);
                    break;
                }
            }
        }
        return position;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        DeviceSession deviceSession;
        ByteBuf buf = (ByteBuf)msg;
        String uniqueId = null;
        if (buf.getByte(0) == 69 && buf.getByte(1) == 76) {
            buf.skipBytes(6);
            uniqueId = ByteBufUtil.hexDump((ByteBuf)buf.readSlice(8)).substring(1);
            deviceSession = this.getDeviceSession(channel, remoteAddress, uniqueId);
        } else {
            deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
        }
        buf.skipBytes(2);
        short type = buf.readUnsignedByte();
        buf.readShort();
        int index = buf.readUnsignedShort();
        if (type != 2 && type != 129) {
            ByteBuf content = Unpooled.buffer();
            if (type == 1) {
                content.writeInt((int)(System.currentTimeMillis() / 1000L));
                content.writeByte(1);
                content.writeByte(0);
            }
            ByteBuf response = EelinkProtocolEncoder.encodeContent(channel instanceof DatagramChannel, uniqueId, type, index, content);
            content.release();
            if (channel != null) {
                channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
            }
        }
        if (type == 1) {
            if (deviceSession == null) {
                this.getDeviceSession(channel, remoteAddress, ByteBufUtil.hexDump((ByteBuf)buf.readSlice(8)).substring(1));
            }
        } else {
            if (deviceSession == null) {
                return null;
            }
            if (type == 2 || type == 4 || type == 5 || type == 6) {
                return this.decodeOld(deviceSession, buf, type, index);
            }
            if (type >= 18 && type <= 25) {
                return this.decodeNew(deviceSession, buf, type, index);
            }
            if (type == 3 && buf.readableBytes() >= 2 || type == 7 && buf.readableBytes() == 4) {
                Position position = new Position(this.getProtocolName());
                position.setDeviceId(deviceSession.getDeviceId());
                this.getLastLocation(position, null);
                this.decodeStatus(position, buf.readUnsignedShort());
                return position;
            }
            if (type == 7) {
                return this.decodeObd(deviceSession, buf);
            }
            if (type == 128) {
                return this.decodeResult(deviceSession, buf, index);
            }
        }
        return null;
    }
}

