/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.serializer.extension;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ServerNameIndicationExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.ExtensionSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerNameIndicationExtensionSerializer
extends ExtensionSerializer<ServerNameIndicationExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ServerNameIndicationExtensionMessage msg;

    public ServerNameIndicationExtensionSerializer(ServerNameIndicationExtensionMessage message) {
        super(message);
        this.msg = message;
    }

    @Override
    public byte[] serializeExtensionContent() {
        LOGGER.debug("Serializing ServerNameIndicationExtensionMessage");
        this.writeServerNameListLength(this.msg);
        this.writeServerNameListBytes(this.msg);
        return this.getAlreadySerialized();
    }

    private void writeServerNameListLength(ServerNameIndicationExtensionMessage msg) {
        this.appendInt((Integer)msg.getServerNameListLength().getValue(), 2);
        LOGGER.debug("ServerNameListLength: " + msg.getServerNameListLength().getValue());
    }

    private void writeServerNameListBytes(ServerNameIndicationExtensionMessage msg) {
        this.appendBytes((byte[])msg.getServerNameListBytes().getValue());
        LOGGER.debug("ServerNameListBytes: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getServerNameListBytes().getValue())));
    }
}

