/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.serializer;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.message.SSL2ClientMasterKeyMessage;
import de.rub.nds.tlsattacker.core.protocol.serializer.ProtocolMessageSerializer;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SSL2ClientMasterKeySerializer
extends ProtocolMessageSerializer<SSL2ClientMasterKeyMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final SSL2ClientMasterKeyMessage msg;

    public SSL2ClientMasterKeySerializer(SSL2ClientMasterKeyMessage message, ProtocolVersion version) {
        super(message, version);
        this.msg = message;
    }

    @Override
    public byte[] serializeProtocolMessageContent() {
        LOGGER.debug("Serializing SSL2ClientMasterKey");
        this.writeMessageLength(this.msg);
        this.writeType(this.msg);
        this.writeCipherKind(this.msg);
        this.writeClearKeyLength(this.msg);
        this.writeEncryptedKeyLength(this.msg);
        this.writeKeyArgLength(this.msg);
        this.writeClearKeyData(this.msg);
        this.writeEncryptedKeyData(this.msg);
        this.writeKeyArgData(this.msg);
        return this.getAlreadySerialized();
    }

    private void writeEncryptedKeyData(SSL2ClientMasterKeyMessage msg) {
        byte[] encryptedKeyData = (byte[])msg.getEncryptedKeyData().getValue();
        this.appendBytes(encryptedKeyData);
        LOGGER.debug("EncryptedKey: " + ArrayConverter.bytesToHexString((byte[])encryptedKeyData));
    }

    private void writeClearKeyData(SSL2ClientMasterKeyMessage msg) {
        byte[] clearKeyData = (byte[])msg.getClearKeyData().getValue();
        this.appendBytes(clearKeyData);
        LOGGER.debug("ClearKey: " + ArrayConverter.bytesToHexString((byte[])clearKeyData));
    }

    private void writeEncryptedKeyLength(SSL2ClientMasterKeyMessage msg) {
        int length = (Integer)msg.getEncryptedKeyLength().getValue();
        this.appendInt(length, 2);
        LOGGER.debug("EncryptedKeyLength: " + length);
    }

    public void writeKeyArgData(SSL2ClientMasterKeyMessage msg) {
        byte[] keyArgData = (byte[])msg.getKeyArgData().getValue();
        this.appendBytes(keyArgData);
        LOGGER.debug("KeyArg: " + ArrayConverter.bytesToHexString((byte[])keyArgData));
    }

    private void writeKeyArgLength(SSL2ClientMasterKeyMessage msg) {
        int length = (Integer)msg.getKeyArgLength().getValue();
        this.appendInt(length, 2);
        LOGGER.debug("EncryptedKeyLength: " + length);
    }

    private void writeClearKeyLength(SSL2ClientMasterKeyMessage msg) {
        int length = (Integer)msg.getClearKeyLength().getValue();
        this.appendInt(length, 2);
        LOGGER.debug("ClearKeyLength: " + length);
    }

    private void writeMessageLength(SSL2ClientMasterKeyMessage msg) {
        if ((Integer)msg.getPaddingLength().getValue() != 0) {
            throw new UnsupportedOperationException("Long record headers are not supported");
        }
        this.appendInt((int)((Integer)msg.getMessageLength().getValue() ^ 0x8000), 2);
        LOGGER.debug("MessageLength: " + msg.getMessageLength().getValue());
    }

    private void writeType(SSL2ClientMasterKeyMessage msg) {
        this.appendByte((Byte)msg.getType().getValue());
        LOGGER.debug("Type: " + msg.getType().getValue());
    }

    private void writeCipherKind(SSL2ClientMasterKeyMessage msg) {
        byte[] cipherKindValue = (byte[])msg.getCipherKind().getValue();
        this.appendBytes(cipherKindValue);
        LOGGER.debug("CipherKind: " + Arrays.toString(cipherKindValue));
    }
}

