/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler.extension;

import de.rub.nds.tlsattacker.core.constants.ECPointFormat;
import de.rub.nds.tlsattacker.core.protocol.handler.extension.ExtensionHandler;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ECPointFormatExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ECPointFormatExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.ECPointFormatExtensionPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.ECPointFormatExtensionSerializer;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import java.util.LinkedList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EcPointFormatExtensionHandler
extends ExtensionHandler<ECPointFormatExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public EcPointFormatExtensionHandler(TlsContext context) {
        super(context);
    }

    @Override
    public void adjustTLSExtensionContext(ECPointFormatExtensionMessage message) {
        byte[] pointFormats;
        LinkedList<ECPointFormat> formatList = new LinkedList<ECPointFormat>();
        for (byte b : pointFormats = (byte[])message.getPointFormats().getValue()) {
            ECPointFormat format = ECPointFormat.getECPointFormat(b);
            if (format != null) {
                formatList.add(format);
                continue;
            }
            LOGGER.warn("Unknown ECPointFormat:" + b);
        }
        if (this.context.getTalkingConnectionEndType() == ConnectionEndType.CLIENT) {
            this.context.setClientPointFormatsList(formatList);
        } else {
            this.context.setServerPointFormatsList(formatList);
        }
    }

    @Override
    public ECPointFormatExtensionParser getParser(byte[] message, int pointer) {
        return new ECPointFormatExtensionParser(pointer, message);
    }

    public ECPointFormatExtensionPreparator getPreparator(ECPointFormatExtensionMessage message) {
        return new ECPointFormatExtensionPreparator(this.context.getChooser(), message, this.getSerializer(message));
    }

    public ECPointFormatExtensionSerializer getSerializer(ECPointFormatExtensionMessage message) {
        return new ECPointFormatExtensionSerializer(message);
    }
}

