/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler;

import de.rub.nds.tlsattacker.core.protocol.handler.ECDHEServerKeyExchangeHandler;
import de.rub.nds.tlsattacker.core.protocol.message.PskEcDheServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.PskEcDheServerKeyExchangeParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.PskEcDheServerKeyExchangePreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.PskEcDheServerKeyExchangeSerializer;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import java.math.BigInteger;

public class PskEcDheServerKeyExchangeHandler
extends ECDHEServerKeyExchangeHandler<PskEcDheServerKeyExchangeMessage> {
    public PskEcDheServerKeyExchangeHandler(TlsContext tlsContext) {
        super(tlsContext);
    }

    @Override
    public PskEcDheServerKeyExchangeParser getParser(byte[] message, int pointer) {
        return new PskEcDheServerKeyExchangeParser(pointer, message, this.tlsContext.getChooser().getLastRecordVersion(), this.tlsContext.getConfig());
    }

    public PskEcDheServerKeyExchangePreparator getPreparator(PskEcDheServerKeyExchangeMessage message) {
        return new PskEcDheServerKeyExchangePreparator(this.tlsContext.getChooser(), message);
    }

    public PskEcDheServerKeyExchangeSerializer getSerializer(PskEcDheServerKeyExchangeMessage message) {
        return new PskEcDheServerKeyExchangeSerializer(message, this.tlsContext.getChooser().getSelectedProtocolVersion());
    }

    @Override
    public void adjustTLSContext(PskEcDheServerKeyExchangeMessage message) {
        super.adjustECParameter(message);
        if (message.getComputations() != null) {
            this.tlsContext.setServerEcPrivateKey((BigInteger)message.getComputations().getPrivateKey().getValue());
        }
    }
}

