/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.lucene.util.IOUtils;
import org.apache.solr.api.Command;
import org.apache.solr.api.CustomContainerPlugins;
import org.apache.solr.api.EndPoint;
import org.apache.solr.api.PayloadObj;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.request.beans.PluginMeta;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerPluginsApi {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PLUGIN = "plugin";
    private final Supplier<SolrZkClient> zkClientSupplier;
    private final CoreContainer coreContainer;
    public final Read readAPI = new Read();
    public final Edit editAPI = new Edit();

    public ContainerPluginsApi(CoreContainer coreContainer) {
        this.zkClientSupplier = coreContainer.zkClientSupplier;
        this.coreContainer = coreContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateConfig(PayloadObj<PluginMeta> payload, PluginMeta info) {
        if (info.klass.indexOf(58) > 0 && info.version == null) {
            payload.addError("Using package. must provide a packageVersion");
            return;
        }
        ArrayList<String> errs = new ArrayList<String>();
        CustomContainerPlugins.ApiInfo apiInfo = this.coreContainer.getCustomContainerPlugins().createInfo(info, errs);
        if (!errs.isEmpty()) {
            for (String err : errs) {
                payload.addError(err);
            }
            return;
        }
        Object api = null;
        try {
            apiInfo.init();
        }
        catch (Exception e) {
            try {
                log.error("Error instantiating plugin ", (Throwable)e);
                errs.add(e.getMessage());
            }
            catch (Throwable throwable) {
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{api});
                throw throwable;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{api});
            return;
        }
        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{api});
    }

    public static Map<String, Object> plugins(Supplier<SolrZkClient> zkClientSupplier) throws IOException {
        SolrZkClient zkClient = zkClientSupplier.get();
        try {
            Map clusterPropsJson = (Map)Utils.fromJSON((byte[])zkClient.getData("/clusterprops.json", null, new Stat(), true));
            return (Map)clusterPropsJson.computeIfAbsent(PLUGIN, Utils.NEW_LINKED_HASHMAP_FUN);
        }
        catch (KeeperException.NoNodeException e) {
            return new LinkedHashMap<String, Object>();
        }
        catch (InterruptedException | KeeperException e) {
            throw new IOException("Error reading cluster property", SolrZkClient.checkInterrupted((Throwable)e));
        }
    }

    private void persistPlugins(Function<Map<String, Object>, Map<String, Object>> modifier) throws IOException {
        try {
            this.zkClientSupplier.get().atomicUpdate("/clusterprops.json", bytes -> {
                Map rawJson = bytes == null ? new LinkedHashMap() : (Map)Utils.fromJSON((byte[])bytes);
                Map pluginsModified = (Map)modifier.apply((Map)rawJson.computeIfAbsent(PLUGIN, Utils.NEW_LINKED_HASHMAP_FUN));
                if (pluginsModified == null) {
                    return null;
                }
                rawJson.put(PLUGIN, pluginsModified);
                return Utils.toJSON(rawJson);
            });
        }
        catch (InterruptedException | KeeperException e) {
            throw new IOException("Error reading cluster property", SolrZkClient.checkInterrupted((Throwable)e));
        }
    }

    @EndPoint(method={SolrRequest.METHOD.POST}, path={"/cluster/plugin"}, permission=PermissionNameProvider.Name.COLL_EDIT_PERM)
    public class Edit {
        @Command(name="add")
        public void add(PayloadObj<PluginMeta> payload) throws IOException {
            PluginMeta info = payload.get();
            ContainerPluginsApi.this.validateConfig(payload, info);
            if (payload.hasError()) {
                return;
            }
            ContainerPluginsApi.this.persistPlugins(map -> {
                if (map.containsKey(info.name)) {
                    payload.addError(info.name + " already exists");
                    return null;
                }
                map.put(info.name, info);
                return map;
            });
        }

        @Command(name="remove")
        public void remove(PayloadObj<String> payload) throws IOException {
            ContainerPluginsApi.this.persistPlugins(map -> {
                if (map.remove(payload.get()) == null) {
                    payload.addError("No such plugin: " + (String)payload.get());
                    return null;
                }
                return map;
            });
        }

        @Command(name="update")
        public void update(PayloadObj<PluginMeta> payload) throws IOException {
            PluginMeta info = payload.get();
            ContainerPluginsApi.this.validateConfig(payload, info);
            if (payload.hasError()) {
                return;
            }
            ContainerPluginsApi.this.persistPlugins(map -> {
                Map existing = (Map)map.get(info.name);
                if (existing == null) {
                    payload.addError("No such plugin: " + info.name);
                    return null;
                }
                map.put(info.name, info);
                return map;
            });
        }
    }

    public class Read {
        @EndPoint(method={SolrRequest.METHOD.GET}, path={"/cluster/plugin"}, permission=PermissionNameProvider.Name.COLL_READ_PERM)
        public void list(SolrQueryRequest req, SolrQueryResponse rsp) throws IOException {
            rsp.add(ContainerPluginsApi.PLUGIN, ContainerPluginsApi.plugins(ContainerPluginsApi.this.zkClientSupplier));
        }
    }
}

