/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xmp.impl.xpath;

import com.adobe.xmp.XMPException;
import com.adobe.xmp.XMPMetaFactory;
import com.adobe.xmp.impl.Utils;
import com.adobe.xmp.impl.xpath.PathPosition;
import com.adobe.xmp.impl.xpath.XMPPath;
import com.adobe.xmp.impl.xpath.XMPPathSegment;
import com.adobe.xmp.properties.XMPAliasInfo;

public final class XMPPathParser {
    private XMPPathParser() {
    }

    public static XMPPath expandXPath(String string, String string2) throws XMPException {
        if (string == null || string2 == null) {
            throw new XMPException("Parameter must not be null", 4);
        }
        XMPPath xMPPath = new XMPPath();
        PathPosition pathPosition = new PathPosition();
        pathPosition.path = string2;
        XMPPathParser.parseRootNode(string, pathPosition, xMPPath);
        while (pathPosition.stepEnd < string2.length()) {
            pathPosition.stepBegin = pathPosition.stepEnd;
            XMPPathParser.skipPathDelimiter(string2, pathPosition);
            pathPosition.stepEnd = pathPosition.stepBegin;
            XMPPathSegment xMPPathSegment = string2.charAt(pathPosition.stepBegin) != '[' ? XMPPathParser.parseStructSegment(pathPosition) : XMPPathParser.parseIndexSegment(pathPosition);
            if (xMPPathSegment.getKind() == 1) {
                if (xMPPathSegment.getName().charAt(0) == '@') {
                    xMPPathSegment.setName("?" + xMPPathSegment.getName().substring(1));
                    if (!"?xml:lang".equals(xMPPathSegment.getName())) {
                        throw new XMPException("Only xml:lang allowed with '@'", 102);
                    }
                }
                if (xMPPathSegment.getName().charAt(0) == '?') {
                    ++pathPosition.nameStart;
                    xMPPathSegment.setKind(2);
                }
                XMPPathParser.verifyQualName(pathPosition.path.substring(pathPosition.nameStart, pathPosition.nameEnd));
            } else if (xMPPathSegment.getKind() == 6) {
                if (xMPPathSegment.getName().charAt(1) == '@') {
                    xMPPathSegment.setName("[?" + xMPPathSegment.getName().substring(2));
                    if (!xMPPathSegment.getName().startsWith("[?xml:lang=")) {
                        throw new XMPException("Only xml:lang allowed with '@'", 102);
                    }
                }
                if (xMPPathSegment.getName().charAt(1) == '?') {
                    ++pathPosition.nameStart;
                    xMPPathSegment.setKind(5);
                    XMPPathParser.verifyQualName(pathPosition.path.substring(pathPosition.nameStart, pathPosition.nameEnd));
                }
            }
            xMPPath.add(xMPPathSegment);
        }
        return xMPPath;
    }

    private static void skipPathDelimiter(String string, PathPosition pathPosition) throws XMPException {
        if (string.charAt(pathPosition.stepBegin) == '/') {
            ++pathPosition.stepBegin;
            if (pathPosition.stepBegin >= string.length()) {
                throw new XMPException("Empty XMPPath segment", 102);
            }
        }
        if (string.charAt(pathPosition.stepBegin) == '*') {
            ++pathPosition.stepBegin;
            if (pathPosition.stepBegin >= string.length() || string.charAt(pathPosition.stepBegin) != '[') {
                throw new XMPException("Missing '[' after '*'", 102);
            }
        }
    }

    private static XMPPathSegment parseStructSegment(PathPosition pathPosition) throws XMPException {
        pathPosition.nameStart = pathPosition.stepBegin;
        while (pathPosition.stepEnd < pathPosition.path.length() && "/[*".indexOf(pathPosition.path.charAt(pathPosition.stepEnd)) < 0) {
            ++pathPosition.stepEnd;
        }
        pathPosition.nameEnd = pathPosition.stepEnd;
        if (pathPosition.stepEnd == pathPosition.stepBegin) {
            throw new XMPException("Empty XMPPath segment", 102);
        }
        XMPPathSegment xMPPathSegment = new XMPPathSegment(pathPosition.path.substring(pathPosition.stepBegin, pathPosition.stepEnd), 1);
        return xMPPathSegment;
    }

    private static XMPPathSegment parseIndexSegment(PathPosition pathPosition) throws XMPException {
        XMPPathSegment xMPPathSegment;
        ++pathPosition.stepEnd;
        if ('0' <= pathPosition.path.charAt(pathPosition.stepEnd) && pathPosition.path.charAt(pathPosition.stepEnd) <= '9') {
            while (pathPosition.stepEnd < pathPosition.path.length() && '0' <= pathPosition.path.charAt(pathPosition.stepEnd) && pathPosition.path.charAt(pathPosition.stepEnd) <= '9') {
                ++pathPosition.stepEnd;
            }
            xMPPathSegment = new XMPPathSegment(null, 3);
        } else {
            while (pathPosition.stepEnd < pathPosition.path.length() && pathPosition.path.charAt(pathPosition.stepEnd) != ']' && pathPosition.path.charAt(pathPosition.stepEnd) != '=') {
                ++pathPosition.stepEnd;
            }
            if (pathPosition.stepEnd >= pathPosition.path.length()) {
                throw new XMPException("Missing ']' or '=' for array index", 102);
            }
            if (pathPosition.path.charAt(pathPosition.stepEnd) == ']') {
                if (!"[last()".equals(pathPosition.path.substring(pathPosition.stepBegin, pathPosition.stepEnd))) {
                    throw new XMPException("Invalid non-numeric array index", 102);
                }
                xMPPathSegment = new XMPPathSegment(null, 4);
            } else {
                pathPosition.nameStart = pathPosition.stepBegin + 1;
                pathPosition.nameEnd = pathPosition.stepEnd++;
                char c = pathPosition.path.charAt(pathPosition.stepEnd);
                if (c != '\'' && c != '\"') {
                    throw new XMPException("Invalid quote in array selector", 102);
                }
                ++pathPosition.stepEnd;
                while (pathPosition.stepEnd < pathPosition.path.length()) {
                    if (pathPosition.path.charAt(pathPosition.stepEnd) == c) {
                        if (pathPosition.stepEnd + 1 >= pathPosition.path.length() || pathPosition.path.charAt(pathPosition.stepEnd + 1) != c) break;
                        ++pathPosition.stepEnd;
                    }
                    ++pathPosition.stepEnd;
                }
                if (pathPosition.stepEnd >= pathPosition.path.length()) {
                    throw new XMPException("No terminating quote for array selector", 102);
                }
                ++pathPosition.stepEnd;
                xMPPathSegment = new XMPPathSegment(null, 6);
            }
        }
        if (pathPosition.stepEnd >= pathPosition.path.length() || pathPosition.path.charAt(pathPosition.stepEnd) != ']') {
            throw new XMPException("Missing ']' for array index", 102);
        }
        ++pathPosition.stepEnd;
        xMPPathSegment.setName(pathPosition.path.substring(pathPosition.stepBegin, pathPosition.stepEnd));
        return xMPPathSegment;
    }

    private static void parseRootNode(String string, PathPosition pathPosition, XMPPath xMPPath) throws XMPException {
        while (pathPosition.stepEnd < pathPosition.path.length() && "/[*".indexOf(pathPosition.path.charAt(pathPosition.stepEnd)) < 0) {
            ++pathPosition.stepEnd;
        }
        if (pathPosition.stepEnd == pathPosition.stepBegin) {
            throw new XMPException("Empty initial XMPPath step", 102);
        }
        String string2 = XMPPathParser.verifyXPathRoot(string, pathPosition.path.substring(pathPosition.stepBegin, pathPosition.stepEnd));
        XMPAliasInfo xMPAliasInfo = XMPMetaFactory.getSchemaRegistry().findAlias(string2);
        if (xMPAliasInfo == null) {
            xMPPath.add(new XMPPathSegment(string, Integer.MIN_VALUE));
            XMPPathSegment xMPPathSegment = new XMPPathSegment(string2, 1);
            xMPPath.add(xMPPathSegment);
        } else {
            xMPPath.add(new XMPPathSegment(xMPAliasInfo.getNamespace(), Integer.MIN_VALUE));
            XMPPathSegment xMPPathSegment = new XMPPathSegment(XMPPathParser.verifyXPathRoot(xMPAliasInfo.getNamespace(), xMPAliasInfo.getPropName()), 1);
            xMPPathSegment.setAlias(true);
            xMPPathSegment.setAliasForm(xMPAliasInfo.getAliasForm().getOptions());
            xMPPath.add(xMPPathSegment);
            if (xMPAliasInfo.getAliasForm().isArrayAltText()) {
                XMPPathSegment xMPPathSegment2 = new XMPPathSegment("[?xml:lang='x-default']", 5);
                xMPPathSegment2.setAlias(true);
                xMPPathSegment2.setAliasForm(xMPAliasInfo.getAliasForm().getOptions());
                xMPPath.add(xMPPathSegment2);
            } else if (xMPAliasInfo.getAliasForm().isArray()) {
                XMPPathSegment xMPPathSegment3 = new XMPPathSegment("[1]", 3);
                xMPPathSegment3.setAlias(true);
                xMPPathSegment3.setAliasForm(xMPAliasInfo.getAliasForm().getOptions());
                xMPPath.add(xMPPathSegment3);
            }
        }
    }

    private static void verifyQualName(String string) throws XMPException {
        String string2;
        int n = string.indexOf(58);
        if (n > 0 && Utils.isXMLNameNS(string2 = string.substring(0, n))) {
            String string3 = XMPMetaFactory.getSchemaRegistry().getNamespaceURI(string2);
            if (string3 != null) {
                return;
            }
            throw new XMPException("Unknown namespace prefix for qualified name", 102);
        }
        throw new XMPException("Ill-formed qualified name", 102);
    }

    private static void verifySimpleXMLName(String string) throws XMPException {
        if (!Utils.isXMLName(string)) {
            throw new XMPException("Bad XML name", 102);
        }
    }

    private static String verifyXPathRoot(String string, String string2) throws XMPException {
        if (string == null || string.length() == 0) {
            throw new XMPException("Schema namespace URI is required", 101);
        }
        if (string2.charAt(0) == '?' || string2.charAt(0) == '@') {
            throw new XMPException("Top level name must not be a qualifier", 102);
        }
        if (string2.indexOf(47) >= 0 || string2.indexOf(91) >= 0) {
            throw new XMPException("Top level name must be simple", 102);
        }
        String string3 = XMPMetaFactory.getSchemaRegistry().getNamespacePrefix(string);
        if (string3 == null) {
            throw new XMPException("Unregistered schema namespace URI", 101);
        }
        int n = string2.indexOf(58);
        if (n < 0) {
            XMPPathParser.verifySimpleXMLName(string2);
            return string3 + string2;
        }
        XMPPathParser.verifySimpleXMLName(string2.substring(0, n));
        XMPPathParser.verifySimpleXMLName(string2.substring(n));
        string3 = string2.substring(0, n + 1);
        String string4 = XMPMetaFactory.getSchemaRegistry().getNamespacePrefix(string);
        if (string4 == null) {
            throw new XMPException("Unknown schema namespace prefix", 101);
        }
        if (!string3.equals(string4)) {
            throw new XMPException("Schema namespace URI and prefix mismatch", 101);
        }
        return string2;
    }
}

