/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl.rules;

import com.intellij.icons.AllIcons;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleGrouper;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.impl.rules.UsageGroupBase;
import com.intellij.usages.rules.UsageGroupingRuleEx;
import com.intellij.usages.rules.UsageInLibrary;
import com.intellij.usages.rules.UsageInModule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ModuleGroupingRule
implements UsageGroupingRuleEx,
DumbAware {
    private final ModuleGrouper myGrouper;
    private final boolean myFlattenModules;

    ModuleGroupingRule(@NotNull Project project, boolean flattenModules) {
        if (project == null) {
            ModuleGroupingRule.$$$reportNull$$$0(0);
        }
        this.myGrouper = ModuleGrouper.instanceFor(project);
        this.myFlattenModules = flattenModules;
    }

    @Override
    @NotNull
    public List<UsageGroup> getParentGroupsFor(@NotNull Usage usage, UsageTarget @NotNull [] targets) {
        UsageInModule usageInModule;
        Module module;
        if (usage == null) {
            ModuleGroupingRule.$$$reportNull$$$0(1);
        }
        if (targets == null) {
            ModuleGroupingRule.$$$reportNull$$$0(2);
        }
        if (usage instanceof UsageInModule && (module = (usageInModule = (UsageInModule)usage).getModule()) != null) {
            if (this.myFlattenModules) {
                List<UsageGroup> list = Collections.singletonList(new ModuleUsageGroup(module, null));
                if (list == null) {
                    ModuleGroupingRule.$$$reportNull$$$0(3);
                }
                return list;
            }
            List<String> groupPath = this.myGrouper.getGroupPath(module);
            ArrayList<UsageGroup> parentGroups = new ArrayList<UsageGroup>(groupPath.size() + 1);
            for (int i = 1; i <= groupPath.size(); ++i) {
                parentGroups.add(new ModuleGroupUsageGroup(groupPath.subList(0, i)));
            }
            parentGroups.add(new ModuleUsageGroup(module, this.myGrouper));
            ArrayList<UsageGroup> arrayList = parentGroups;
            if (arrayList == null) {
                ModuleGroupingRule.$$$reportNull$$$0(4);
            }
            return arrayList;
        }
        if (usage instanceof UsageInLibrary) {
            UsageInLibrary usageInLibrary = (UsageInLibrary)usage;
            OrderEntry entry = usageInLibrary.getLibraryEntry();
            if (entry != null) {
                List<UsageGroup> list = Collections.singletonList(new LibraryUsageGroup(entry));
                if (list == null) {
                    ModuleGroupingRule.$$$reportNull$$$0(5);
                }
                return list;
            }
            for (SyntheticLibrary syntheticLibrary : usageInLibrary.getSyntheticLibraries()) {
                if (!(syntheticLibrary instanceof ItemPresentation)) continue;
                List<UsageGroup> list = Collections.singletonList(new SyntheticLibraryUsageGroup((ItemPresentation)syntheticLibrary));
                if (list == null) {
                    ModuleGroupingRule.$$$reportNull$$$0(6);
                }
                return list;
            }
        }
        List<UsageGroup> list = Collections.emptyList();
        if (list == null) {
            ModuleGroupingRule.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Override
    @Nullable
    public String getGroupingActionId() {
        return "UsageGrouping.Module";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/usages/impl/rules/ModuleGroupingRule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/usages/impl/rules/ModuleGroupingRule";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentGroupsFor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getParentGroupsFor";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ModuleGroupUsageGroup
    extends UsageGroupBase {
        private final List<String> myGroupPath;

        ModuleGroupUsageGroup(@NotNull List<String> groupPath) {
            if (groupPath == null) {
                ModuleGroupUsageGroup.$$$reportNull$$$0(0);
            }
            super(0);
            this.myGroupPath = groupPath;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o instanceof ModuleGroupUsageGroup && this.myGroupPath.equals(((ModuleGroupUsageGroup)o).myGroupPath);
        }

        public int hashCode() {
            return this.myGroupPath.hashCode();
        }

        @Override
        public Icon getIcon(boolean isOpen) {
            return AllIcons.Nodes.ModuleGroup;
        }

        @Override
        @NotNull
        public String getText(UsageView view) {
            String string = this.myGroupPath.get(this.myGroupPath.size() - 1);
            if (string == null) {
                ModuleGroupUsageGroup.$$$reportNull$$$0(1);
            }
            return string;
        }

        public String toString() {
            return UsageViewBundle.message("node.group.module.group", new Object[0]) + this.getText(null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "groupPath";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/usages/impl/rules/ModuleGroupingRule$ModuleGroupUsageGroup";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/usages/impl/rules/ModuleGroupingRule$ModuleGroupUsageGroup";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ModuleUsageGroup
    extends UsageGroupBase
    implements TypeSafeDataProvider {
        private final Module myModule;
        private final ModuleGrouper myGrouper;

        ModuleUsageGroup(@NotNull Module module, @Nullable ModuleGrouper grouper) {
            if (module == null) {
                ModuleUsageGroup.$$$reportNull$$$0(0);
            }
            super(1);
            this.myModule = module;
            this.myGrouper = grouper;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ModuleUsageGroup)) {
                return false;
            }
            ModuleUsageGroup moduleUsageGroup = (ModuleUsageGroup)o;
            return this.myModule.equals(moduleUsageGroup.myModule);
        }

        public int hashCode() {
            return this.myModule.hashCode();
        }

        @Override
        public Icon getIcon(boolean isOpen) {
            return this.myModule.isDisposed() ? null : ModuleType.get(this.myModule).getIcon();
        }

        @Override
        @NotNull
        public String getText(UsageView view) {
            String string = this.myModule.isDisposed() ? "" : (this.myGrouper != null ? this.myGrouper.getShortenedName(this.myModule) : this.myModule.getName());
            if (string == null) {
                ModuleUsageGroup.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public boolean isValid() {
            return !this.myModule.isDisposed();
        }

        public String toString() {
            return UsageViewBundle.message("node.group.module", new Object[0]) + this.getText(null);
        }

        @Override
        public void calcData(@NotNull DataKey key, @NotNull DataSink sink) {
            if (key == null) {
                ModuleUsageGroup.$$$reportNull$$$0(2);
            }
            if (sink == null) {
                ModuleUsageGroup.$$$reportNull$$$0(3);
            }
            if (!this.isValid()) {
                return;
            }
            if (LangDataKeys.MODULE_CONTEXT == key) {
                sink.put(LangDataKeys.MODULE_CONTEXT, this.myModule);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/usages/impl/rules/ModuleGroupingRule$ModuleUsageGroup";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sink";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/usages/impl/rules/ModuleGroupingRule$ModuleUsageGroup";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "calcData";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class SyntheticLibraryUsageGroup
    extends UsageGroupBase {
        @NotNull
        private final ItemPresentation myItemPresentation;

        SyntheticLibraryUsageGroup(@NotNull ItemPresentation itemPresentation) {
            if (itemPresentation == null) {
                SyntheticLibraryUsageGroup.$$$reportNull$$$0(0);
            }
            super(2);
            this.myItemPresentation = itemPresentation;
        }

        @Override
        public Icon getIcon(boolean isOpen) {
            return this.myItemPresentation.getIcon(false);
        }

        @Override
        @NotNull
        public String getText(UsageView view) {
            String string = StringUtil.notNullize((String)this.myItemPresentation.getPresentableText(), (String)"Library");
            if (string == null) {
                SyntheticLibraryUsageGroup.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o instanceof SyntheticLibraryUsageGroup && this.myItemPresentation.equals(((SyntheticLibraryUsageGroup)o).myItemPresentation);
        }

        public int hashCode() {
            return this.myItemPresentation.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "itemPresentation";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/usages/impl/rules/ModuleGroupingRule$SyntheticLibraryUsageGroup";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/usages/impl/rules/ModuleGroupingRule$SyntheticLibraryUsageGroup";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class LibraryUsageGroup
    extends UsageGroupBase {
        private final OrderEntry myEntry;

        LibraryUsageGroup(@NotNull OrderEntry entry) {
            if (entry == null) {
                LibraryUsageGroup.$$$reportNull$$$0(0);
            }
            super(2);
            this.myEntry = entry;
        }

        @Override
        public Icon getIcon(boolean isOpen) {
            return AllIcons.Nodes.PpLibFolder;
        }

        @Override
        @NotNull
        public String getText(UsageView view) {
            String string = this.myEntry.getPresentableName();
            if (string == null) {
                LibraryUsageGroup.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o instanceof LibraryUsageGroup && this.myEntry.equals(((LibraryUsageGroup)o).myEntry);
        }

        public int hashCode() {
            return this.myEntry.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entry";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/usages/impl/rules/ModuleGroupingRule$LibraryUsageGroup";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/usages/impl/rules/ModuleGroupingRule$LibraryUsageGroup";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

