/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor;

import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import org.jetbrains.annotations.NotNull;

public class PsiElementNavigatable
implements Navigatable {
    private final SmartPsiElementPointer<PsiElement> myPointer;

    public PsiElementNavigatable(@NotNull PsiElement element) {
        if (element == null) {
            PsiElementNavigatable.$$$reportNull$$$0(0);
        }
        this.myPointer = SmartPointerManager.getInstance(element.getProject()).createSmartPsiElementPointer(element);
    }

    @Override
    public final void navigate(final boolean requestFocus) {
        VirtualFile file;
        final PsiElement element = this.getElement();
        if (element != null && (file = element.getContainingFile().getVirtualFile()) != null) {
            new Task.Modal(element.getProject(), EditorBundle.message("editor.open.file.progress", file.getName()), true){

                @Override
                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    int offset = (Integer)ReadAction.compute(() -> element.isValid() ? element.getTextOffset() : -1);
                    indicator.checkCanceled();
                    if (offset >= 0) {
                        Navigatable descriptor = PsiNavigationSupport.getInstance().createNavigatable(this.myProject, file, offset);
                        Condition isValid = __ -> !file.isValid();
                        Condition isDisposed = this.myProject.getDisposed();
                        Condition expired = Conditions.or((Condition)isDisposed, (Condition)isValid);
                        ApplicationManager.getApplication().invokeLater(() -> descriptor.navigate(requestFocus), expired);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/fileEditor/PsiElementNavigatable$1", "run"));
                }
            }.queue();
        }
    }

    @Override
    public boolean canNavigate() {
        PsiElement element = this.getElement();
        return element != null && element.getContainingFile().getVirtualFile() != null;
    }

    private PsiElement getElement() {
        PsiElement element = this.myPointer.getElement();
        if (element != null && element.isValid()) {
            PsiElement navigationElement = element.getNavigationElement();
            return navigationElement != null ? navigationElement : element;
        }
        return null;
    }

    @Override
    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/fileEditor/PsiElementNavigatable", "<init>"));
    }
}

