/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.ex;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.HelpTooltip;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.UserActivityProviderComponent;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MouseEventAdapter;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Path2D;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ComboBoxAction
extends AnAction
implements CustomComponentAction {
    private static Icon myIcon;
    private static Icon myDisabledIcon;
    private boolean mySmallVariant = true;
    private String myPopupTitle;

    public static Icon getArrowIcon(boolean enabled) {
        if (myIcon != AllIcons.General.ArrowDown) {
            myIcon = UIManager.getIcon("ComboBoxButton.arrowIcon");
            myDisabledIcon = UIManager.getIcon("ComboBoxButton.arrowIconDisabled");
            if (myIcon == null) {
                myIcon = AllIcons.General.ArrowDown;
            }
            if (myDisabledIcon == null) {
                myDisabledIcon = IconLoader.getDisabledIcon((Icon)AllIcons.General.ArrowDown);
            }
        }
        return enabled ? myIcon : myDisabledIcon;
    }

    protected ComboBoxAction() {
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ComboBoxAction.$$$reportNull$$$0(0);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        JFrame frame = WindowManager.getInstance().getFrame(project);
        if (!(frame instanceof IdeFrame)) {
            return;
        }
        ListPopup popup = this.createActionPopup(e.getDataContext(), ((IdeFrame)((Object)frame)).getComponent(), null);
        popup.showCenteredInCurrentWindow(project);
    }

    @NotNull
    private ListPopup createActionPopup(@NotNull DataContext context, @NotNull JComponent component, @Nullable Runnable disposeCallback) {
        if (context == null) {
            ComboBoxAction.$$$reportNull$$$0(1);
        }
        if (component == null) {
            ComboBoxAction.$$$reportNull$$$0(2);
        }
        DefaultActionGroup group = this.createPopupActionGroup(component, context);
        ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup(this.myPopupTitle, (ActionGroup)group, context, false, this.shouldShowDisabledActions(), false, disposeCallback, this.getMaxRows(), this.getPreselectCondition());
        popup.setMinimumSize(new Dimension(this.getMinWidth(), this.getMinHeight()));
        ListPopup listPopup = popup;
        if (listPopup == null) {
            ComboBoxAction.$$$reportNull$$$0(3);
        }
        return listPopup;
    }

    @Override
    @Deprecated
    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation) {
        if (presentation == null) {
            ComboBoxAction.$$$reportNull$$$0(4);
        }
        JComponent jComponent = this.createCustomComponent(presentation, "unknown");
        if (jComponent == null) {
            ComboBoxAction.$$$reportNull$$$0(5);
        }
        return jComponent;
    }

    @Override
    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
        if (presentation == null) {
            ComboBoxAction.$$$reportNull$$$0(6);
        }
        if (place == null) {
            ComboBoxAction.$$$reportNull$$$0(7);
        }
        JPanel panel2 = new JPanel(new GridBagLayout());
        ComboBoxButton button = this.createComboBoxButton(presentation);
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, (Insets)JBInsets.create((int)0, (int)3), 0, 0);
        panel2.add((Component)button, constraints);
        JPanel jPanel = panel2;
        if (jPanel == null) {
            ComboBoxAction.$$$reportNull$$$0(8);
        }
        return jPanel;
    }

    protected ComboBoxButton createComboBoxButton(Presentation presentation) {
        return new ComboBoxButton(presentation);
    }

    public boolean isSmallVariant() {
        return this.mySmallVariant;
    }

    public void setSmallVariant(boolean smallVariant) {
        this.mySmallVariant = smallVariant;
    }

    public void setPopupTitle(String popupTitle) {
        this.myPopupTitle = popupTitle;
    }

    protected boolean shouldShowDisabledActions() {
        return false;
    }

    @NotNull
    protected abstract DefaultActionGroup createPopupActionGroup(JComponent var1);

    @NotNull
    protected DefaultActionGroup createPopupActionGroup(JComponent button, @NotNull DataContext dataContext) {
        if (dataContext == null) {
            ComboBoxAction.$$$reportNull$$$0(9);
        }
        DefaultActionGroup defaultActionGroup = this.createPopupActionGroup(button);
        if (defaultActionGroup == null) {
            ComboBoxAction.$$$reportNull$$$0(10);
        }
        return defaultActionGroup;
    }

    protected int getMaxRows() {
        return 30;
    }

    protected int getMinHeight() {
        return 1;
    }

    protected int getMinWidth() {
        return 1;
    }

    protected Condition<AnAction> getPreselectCondition() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/actionSystem/ex/ComboBoxAction";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/actionSystem/ex/ComboBoxAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionPopup";
                break;
            }
            case 5: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createCustomComponent";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopupActionGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createActionPopup";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createCustomComponent";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createPopupActionGroup";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected class ComboBoxButton
    extends JButton
    implements UserActivityProviderComponent {
        private final Presentation myPresentation;
        private boolean myForcePressed;
        private String myTooltipText;

        public ComboBoxButton(Presentation presentation) {
            this.myPresentation = presentation;
            this.setIcon(this.myPresentation.getIcon());
            this.setText(this.myPresentation.getText());
            this.setEnabled(this.myPresentation.isEnabled());
            this.myTooltipText = this.myPresentation.getDescription();
            this.updateTooltipText();
            this.setModel(new MyButtonModel());
            this.getModel().setEnabled(this.myPresentation.isEnabled());
            this.setVisible(presentation.isVisible());
            this.setHorizontalAlignment(2);
            this.setFocusable(ScreenReader.isActive());
            this.putClientProperty("styleCombo", ComboBoxAction.this);
            this.setMargin((Insets)JBUI.insets((int)0, (int)8, (int)0, (int)5));
            if (ComboBoxAction.this.isSmallVariant()) {
                this.setFont((Font)JBUI.Fonts.toolbarSmallComboBoxFont());
            }
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (SwingUtilities.isLeftMouseButton(e)) {
                        e.consume();
                        if (e.isShiftDown()) {
                            ComboBoxButton.this.doShiftClick();
                        } else {
                            ComboBoxButton.this.doClick();
                        }
                    }
                }
            });
            this.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    this.mouseMoved(MouseEventAdapter.convert((MouseEvent)e, (Component)e.getComponent(), (int)503, (long)e.getWhen(), (int)(e.getModifiers() | e.getModifiersEx()), (int)e.getX(), (int)e.getY()));
                }
            });
            this.myPresentation.addPropertyChangeListener(evt -> {
                String propertyName = evt.getPropertyName();
                if ("text".equals(propertyName)) {
                    this.setText((String)evt.getNewValue());
                } else if ("description".equals(propertyName)) {
                    this.myTooltipText = (String)evt.getNewValue();
                    this.updateTooltipText();
                } else if ("icon".equals(propertyName)) {
                    this.setIcon((Icon)evt.getNewValue());
                } else if ("enabled".equals(propertyName)) {
                    this.setEnabled((Boolean)evt.getNewValue());
                }
            });
        }

        @Override
        protected void fireActionPerformed(ActionEvent event) {
            if (!this.myForcePressed) {
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> this.showPopup());
            }
        }

        @NotNull
        private Runnable setForcePressed() {
            this.myForcePressed = true;
            this.repaint();
            Runnable runnable = () -> {
                ApplicationManager.getApplication().invokeLater(() -> {
                    this.myForcePressed = false;
                    this.repaint();
                }, ModalityState.any());
                this.repaint();
                this.fireStateChanged();
            };
            if (runnable == null) {
                ComboBoxButton.$$$reportNull$$$0(0);
            }
            return runnable;
        }

        @Override
        @Nullable
        public String getToolTipText() {
            return this.myForcePressed || Registry.is((String)"ide.helptooltip.enabled") ? null : super.getToolTipText();
        }

        public void showPopup() {
            JBPopup popup = this.createPopup(this.setForcePressed());
            if (Registry.is((String)"ide.helptooltip.enabled")) {
                HelpTooltip.setMasterPopup(this, popup);
            }
            popup.showUnderneathOf(this);
        }

        protected JBPopup createPopup(Runnable onDispose) {
            return ComboBoxAction.this.createActionPopup(this.getDataContext(), this, onDispose);
        }

        protected DataContext getDataContext() {
            return DataManager.getInstance().getDataContext(this);
        }

        @Override
        public void removeNotify() {
            HelpTooltip.dispose(this);
            super.removeNotify();
        }

        @Override
        public void addNotify() {
            super.addNotify();
            this.updateTooltipText();
        }

        private void updateTooltipText() {
            HelpTooltip.dispose(this);
            if (Registry.is((String)"ide.helptooltip.enabled") && StringUtil.isNotEmpty((String)this.myTooltipText)) {
                String shortcut = KeymapUtil.getFirstKeyboardShortcutText(ComboBoxAction.this);
                new HelpTooltip().setTitle(this.myTooltipText).setShortcut(shortcut).installOn(this);
            } else {
                String tooltip = KeymapUtil.createTooltipText(this.myTooltipText, ComboBoxAction.this);
                this.setToolTipText(!tooltip.isEmpty() ? tooltip : null);
            }
        }

        @Override
        public boolean isOpaque() {
            return !ComboBoxAction.this.isSmallVariant();
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension prefSize = super.getPreferredSize();
            Insets i = this.getInsets();
            int width = prefSize.width + (StringUtil.isNotEmpty((String)this.getText()) ? this.getIconTextGap() : 0) + (this.myPresentation == null || !this.isArrowVisible(this.myPresentation) ? 0 : JBUIScale.scale((int)16));
            int height = ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE.height + i.top + i.bottom;
            if (!ComboBoxAction.this.isSmallVariant()) {
                height = Math.max(height, prefSize.height);
            }
            Dimension size = new Dimension(width, height);
            JBInsets.addTo((Dimension)size, (Insets)this.getMargin());
            return size;
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(super.getMinimumSize().width, this.getPreferredSize().height);
        }

        @Override
        public Font getFont() {
            return ComboBoxAction.this.isSmallVariant() ? UIUtil.getToolbarFont() : UIUtil.getLabelFont();
        }

        @Override
        protected Graphics getComponentGraphics(Graphics graphics) {
            return JBSwingUtilities.runGlobalCGTransform((JComponent)this, (Graphics)super.getComponentGraphics(graphics));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (!this.isArrowVisible(this.myPresentation)) {
                return;
            }
            if (UIUtil.isUnderWin10LookAndFeel()) {
                Icon icon = ComboBoxAction.getArrowIcon(this.isEnabled());
                int x = this.getWidth() - icon.getIconWidth() - this.getInsets().right - this.getMargin().right - JBUIScale.scale((int)3);
                int y = (this.getHeight() - icon.getIconHeight()) / 2;
                icon.paintIcon(null, g, x, y);
            } else {
                Graphics2D g2 = (Graphics2D)g.create();
                try {
                    int iconSize = JBUIScale.scale((int)16);
                    int x = this.getWidth() - iconSize - this.getInsets().right - this.getMargin().right;
                    int y = (this.getHeight() - iconSize) / 2;
                    g2.translate(x, y);
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
                    g2.setColor(JBUI.CurrentTheme.Arrow.foregroundColor((boolean)this.isEnabled()));
                    Path2D.Float arrow = new Path2D.Float(0);
                    ((Path2D)arrow).moveTo(JBUIScale.scale((float)3.5f), JBUIScale.scale((float)6.0f));
                    ((Path2D)arrow).lineTo(JBUIScale.scale((float)12.5f), JBUIScale.scale((float)6.0f));
                    ((Path2D)arrow).lineTo(JBUIScale.scale((float)8.0f), JBUIScale.scale((float)11.0f));
                    arrow.closePath();
                    g2.fill(arrow);
                }
                finally {
                    g2.dispose();
                }
            }
        }

        protected boolean isArrowVisible(@NotNull Presentation presentation) {
            if (presentation == null) {
                ComboBoxButton.$$$reportNull$$$0(1);
            }
            return true;
        }

        @Override
        public void updateUI() {
            super.updateUI();
            this.setMargin((Insets)JBUI.insets((int)0, (int)8, (int)0, (int)5));
        }

        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
        protected void updateButtonSize() {
        }

        @ApiStatus.Experimental
        protected void doShiftClick() {
            this.doClick();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/actionSystem/ex/ComboBoxAction$ComboBoxButton";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setForcePressed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/actionSystem/ex/ComboBoxAction$ComboBoxButton";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isArrowVisible";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        protected class MyButtonModel
        extends DefaultButtonModel {
            protected MyButtonModel() {
            }

            @Override
            public boolean isPressed() {
                return ComboBoxButton.this.myForcePressed || super.isPressed();
            }

            @Override
            public boolean isArmed() {
                return ComboBoxButton.this.myForcePressed || super.isArmed();
            }
        }
    }
}

