/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.references;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.xml.XmlProperty;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.pom.references.PomService;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PropertyReferenceBase
implements PsiPolyVariantReference,
EmptyResolveMessageProvider {
    protected final String myKey;
    protected final PsiElement myElement;
    protected boolean mySoft;
    private final TextRange myTextRange;

    public PropertyReferenceBase(@NotNull String key, boolean soft, @NotNull PsiElement element) {
        if (key == null) {
            PropertyReferenceBase.$$$reportNull$$$0(0);
        }
        if (element == null) {
            PropertyReferenceBase.$$$reportNull$$$0(1);
        }
        this(key, soft, element, ElementManipulators.getValueTextRange((PsiElement)element));
    }

    public PropertyReferenceBase(@NotNull String key, boolean soft, @NotNull PsiElement element, TextRange range) {
        if (key == null) {
            PropertyReferenceBase.$$$reportNull$$$0(2);
        }
        if (element == null) {
            PropertyReferenceBase.$$$reportNull$$$0(3);
        }
        this.myKey = key;
        this.mySoft = soft;
        this.myElement = element;
        this.myTextRange = range;
    }

    public PsiElement resolve() {
        ResolveResult[] resolveResults = this.multiResolve(false);
        return resolveResults.length == 1 ? resolveResults[0].getElement() : null;
    }

    @NotNull
    protected String getKeyText() {
        String string = this.myKey;
        if (string == null) {
            PropertyReferenceBase.$$$reportNull$$$0(4);
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyReferenceBase other = (PropertyReferenceBase)o;
        return this.getElement() == other.getElement() && this.getKeyText().equals(other.getKeyText());
    }

    public int hashCode() {
        return this.getKeyText().hashCode();
    }

    @NotNull
    public PsiElement getElement() {
        PsiElement psiElement = this.myElement;
        if (psiElement == null) {
            PropertyReferenceBase.$$$reportNull$$$0(5);
        }
        return psiElement;
    }

    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = this.myTextRange;
        if (textRange == null) {
            PropertyReferenceBase.$$$reportNull$$$0(6);
        }
        return textRange;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myKey;
        if (string == null) {
            PropertyReferenceBase.$$$reportNull$$$0(7);
        }
        return string;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            PropertyReferenceBase.$$$reportNull$$$0(8);
        }
        return ElementManipulators.handleContentChange((PsiElement)this.myElement, (TextRange)this.getRangeInElement(), (String)newElementName);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            PropertyReferenceBase.$$$reportNull$$$0(9);
        }
        throw new IncorrectOperationException("not implemented");
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            PropertyReferenceBase.$$$reportNull$$$0(10);
        }
        if (!PropertyReferenceBase.isProperty(element)) {
            return false;
        }
        for (ResolveResult result : this.multiResolve(false)) {
            PsiElement el = result.getElement();
            if (el == null || !el.isEquivalentTo(element)) continue;
            return true;
        }
        return false;
    }

    protected void addKey(Object property, Set<Object> variants) {
        variants.add(property);
    }

    protected void setSoft(boolean soft) {
        this.mySoft = soft;
    }

    public boolean isSoft() {
        return this.mySoft;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = PropertiesBundle.message("unresolved.property.key", new Object[0]);
        if (string == null) {
            PropertyReferenceBase.$$$reportNull$$$0(11);
        }
        return string;
    }

    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        List<Object> properties;
        String key = this.getKeyText();
        List<PropertiesFile> propertiesFiles = this.getPropertiesFiles();
        if (propertiesFiles == null) {
            properties = PropertiesImplUtil.findPropertiesByKey(this.getElement().getProject(), key);
        } else {
            properties = new ArrayList();
            for (PropertiesFile propertiesFile : propertiesFiles) {
                properties.addAll(propertiesFile.findPropertiesByKey(key));
            }
        }
        ContainerUtil.quickSort(properties, (o1, o2) -> {
            String name1 = o1.getPropertiesFile().getName();
            String name2 = o2.getPropertiesFile().getName();
            return Comparing.compare((Comparable)((Object)name1), (Comparable)((Object)name2));
        });
        return PropertyReferenceBase.getResolveResults(properties);
    }

    private static ResolveResult @NotNull [] getResolveResults(List<? extends IProperty> properties) {
        if (properties.isEmpty()) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                PropertyReferenceBase.$$$reportNull$$$0(12);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        ResolveResult[] results = new ResolveResult[properties.size()];
        for (int i = 0; i < properties.size(); ++i) {
            IProperty property = properties.get(i);
            results[i] = new PsiElementResolveResult(property instanceof PsiElement ? (PsiElement)property : PomService.convertToPsi((PsiTarget)((PsiTarget)property)));
        }
        if (results == null) {
            PropertyReferenceBase.$$$reportNull$$$0(13);
        }
        return results;
    }

    @Nullable
    protected abstract List<PropertiesFile> getPropertiesFiles();

    private static boolean isProperty(PsiElement element) {
        if (element instanceof IProperty) {
            return true;
        }
        if (element instanceof PomTargetPsiElement) {
            return ((PomTargetPsiElement)element).getTarget() instanceof XmlProperty;
        }
        if (element instanceof XmlTag && ((XmlTag)element).getName().equals("entry")) {
            return PropertiesImplUtil.isPropertiesFile(element.getContainingFile());
        }
        return false;
    }

    public static boolean isPropertyPsi(@NotNull PsiElement target) {
        if (target == null) {
            PropertyReferenceBase.$$$reportNull$$$0(14);
        }
        return target instanceof IProperty || target instanceof PomTargetPsiElement && ((PomTargetPsiElement)target).getTarget() instanceof IProperty;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 1: 
            case 3: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/properties/references/PropertyReferenceBase";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/properties/references/PropertyReferenceBase";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveResults";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isPropertyPsi";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

