/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.lang.properties.CustomResourceBundleState;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomResourceBundle
extends ResourceBundle {
    private static final Logger LOG = Logger.getInstance(CustomResourceBundle.class);
    private final List<PropertiesFile> myFiles;
    private final String myBaseName;

    private CustomResourceBundle(List<PropertiesFile> files, @NotNull String baseName) {
        if (baseName == null) {
            CustomResourceBundle.$$$reportNull$$$0(0);
        }
        LOG.assertTrue(!files.isEmpty());
        this.myFiles = ContainerUtil.sorted(files, Comparator.comparing(PropertiesFile::getName));
        this.myBaseName = baseName;
    }

    public static CustomResourceBundle fromState(CustomResourceBundleState state, Project project) {
        List files = ContainerUtil.mapNotNull(state.getFiles(VirtualFileManager.getInstance()), virtualFile -> PropertiesImplUtil.getPropertiesFile(virtualFile, project));
        return files.size() < 2 ? null : new CustomResourceBundle(files, state.getBaseName());
    }

    @Override
    @NotNull
    public List<PropertiesFile> getPropertiesFiles() {
        List<PropertiesFile> list = this.myFiles;
        if (list == null) {
            CustomResourceBundle.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @NotNull
    public PropertiesFile getDefaultPropertiesFile() {
        PropertiesFile propertiesFile = (PropertiesFile)ContainerUtil.getFirstItem(this.myFiles);
        if (propertiesFile == null) {
            CustomResourceBundle.$$$reportNull$$$0(2);
        }
        return propertiesFile;
    }

    @Override
    @NotNull
    public String getBaseName() {
        String string = this.myBaseName;
        if (string == null) {
            CustomResourceBundle.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @Nullable
    public VirtualFile getBaseDirectory() {
        VirtualFile baseDir = null;
        for (PropertiesFile file : this.myFiles) {
            VirtualFile currentBaseDir = file.getContainingFile().getContainingDirectory().getVirtualFile();
            if (baseDir == null) {
                baseDir = currentBaseDir;
                continue;
            }
            if (baseDir.equals(currentBaseDir)) continue;
            return null;
        }
        return baseDir;
    }

    @Override
    public boolean isValid() {
        for (PropertiesFile file : this.myFiles) {
            if (file.getContainingFile().isValid()) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomResourceBundle resourceBundle = (CustomResourceBundle)o;
        return resourceBundle.getPropertiesFiles().equals(this.getPropertiesFiles()) && resourceBundle.getBaseName().equals(this.getBaseName());
    }

    public int hashCode() {
        return this.myFiles.hashCode() * 31 + this.myBaseName.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/properties/CustomResourceBundle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/properties/CustomResourceBundle";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertiesFiles";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultPropertiesFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

